package com.zzsn.event.service;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.util.DateUtil;
import com.zzsn.event.util.EsDateUtil;
import com.zzsn.event.util.EsIndexUtil;
import com.zzsn.event.vo.DisplayInfo;
import com.zzsn.event.vo.SubjectInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Slf4j
@Service
public class SubjectDisplayServive {

    @Autowired
    private RestHighLevelClient client;


    /**
     * 分页获取数据
     *
     * @param subjectInfo          查询条件封装
     * @param offset               页数
     * @param pageSize             每页条数
     * @param labelIds
     * @param socialCreditCodeList 企业信用代码集合
     * @param sourceId
     * @throws Exception 异常
     */
    public IPage<DisplayInfo> frontListByPage(String objectType, String objectId, String userId, SubjectInfoVo subjectInfo, String video, int offset, int pageSize,
                                              String column, String order, String crawler, String isSubject, String subjectType, String labelIds, List<String> socialCreditCodeList, String sourceId, Integer isCustomer) throws Exception {
        String[] indexs = EsIndexUtil.getIndexIntervalYear(Constants.ES_DATA_FOR_SUBJECT, subjectInfo.getStartTime(), subjectInfo.getEndTime());
        SearchRequest searchRequest = new SearchRequest(Constants.ES_DATA_FOR_SUBJECT);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        //设置分页参数
        searchSourceBuilder.size(pageSize);
        searchSourceBuilder.from((offset - 1) * pageSize);
        //默认按照置顶以及时间倒序排列
        //根据topNum正序查找，查询置顶数据
        searchSourceBuilder.sort("topNum", SortOrder.DESC);
        if (column.equals("score")) {
            if (order.equals("asc")) {
                searchSourceBuilder.sort("score", SortOrder.ASC);
                searchSourceBuilder.sort("publishDate", SortOrder.ASC);
            } else if (order.equals("desc")) {
                searchSourceBuilder.sort("score", SortOrder.DESC);
                searchSourceBuilder.sort("publishDate", SortOrder.DESC);
            }
        } else if (column.equals("publishDate")) {
            if (order.equals("desc")) {
                searchSourceBuilder.sort("publishDate", SortOrder.DESC);
                searchSourceBuilder.sort("score", SortOrder.DESC);
            } else if (order.equals("asc")) {
                searchSourceBuilder.sort("publishDate", SortOrder.ASC);
                searchSourceBuilder.sort("score", SortOrder.ASC);
            }
        }
        //默认最大数量是10000，设置为true后，显示准确数量
        searchSourceBuilder.trackTotalHits(true);
        //创建查询对象
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


        boolQuery.must(QueryBuilders.matchQuery("subjectId", subjectInfo.getSubjectId()));

        if (StringUtils.isNotEmpty(subjectInfo.getSearch())) {
            boolQuery.must(QueryBuilders.multiMatchQuery(subjectInfo.getSearch(), "title", "content"));
        }
        if (StringUtils.isNotEmpty(subjectInfo.getContent())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery("content", subjectInfo.getContent()));
        }
        if (StringUtils.isNotEmpty(subjectInfo.getTitle())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery("title", subjectInfo.getTitle()));
        }
        if (StringUtils.isNotEmpty(subjectInfo.getOrigin())) {
            boolQuery.must(QueryBuilders.matchPhraseQuery("origin", subjectInfo.getOrigin()));
        }
        if (StringUtils.isNotEmpty(subjectInfo.getSourceAddress())) {
            boolQuery.must(QueryBuilders.termQuery("sourceAddress", subjectInfo.getSourceAddress()));
        }
        if (StringUtils.isNotEmpty(subjectInfo.getId())) {
            boolQuery.must(QueryBuilders.termQuery("id", subjectInfo.getId()));
        }
        if (subjectInfo.getCheckStatusList() != null && subjectInfo.getCheckStatusList().size() > 0) {
            List<Integer> list = new ArrayList<>();
            list = subjectInfo.getCheckStatusList();
            if (list.size() == 1 && list.contains(4)) {
                //
            } else {
                boolQuery.must(QueryBuilders.termsQuery("checkStatus", subjectInfo.getCheckStatusList()));
            }
        }
        if (StringUtils.isNotBlank(video)) {
            boolQuery.must(QueryBuilders.matchQuery("type", "video"));
        } else {
            boolQuery.mustNot(QueryBuilders.matchQuery("type", "video"));
        }
        //只查询主条目
        boolQuery.mustNot(QueryBuilders.matchQuery("flag", "0"));
        //删除状态查询
        if (subjectInfo.getDeleteFlag() != 0) {
            boolQuery.must(QueryBuilders.matchQuery("deleteFlag", "1"));
        } else {
            boolQuery.mustNot(QueryBuilders.matchQuery("deleteFlag", "1"));
        }

        //专题库类别筛选
        if (subjectInfo.getClassificationType() != null) {
            boolQuery.must(QueryBuilders.termQuery("classificationType", subjectInfo.getClassificationType()));
        }

        //正负面
        if (subjectInfo.getOrientation() != null) {
            boolQuery.must(QueryBuilders.termQuery("orientation", subjectInfo.getOrientation()));
        }

        //时间过滤筛选
        if (StringUtils.isNotBlank(subjectInfo.getStartTime())) {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").gte(EsDateUtil.esFieldDateFormat(subjectInfo.getStartTime())));
        }
        if (StringUtils.isNotBlank(subjectInfo.getEndTime())) {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").lte(EsDateUtil.esFieldDateFormat(subjectInfo.getEndTime())));
        } else {
            boolQuery.filter(QueryBuilders.rangeQuery("publishDate").lte(EsDateUtil.esFieldDateFormat(DateUtil.dateToString(new Date()))));
        }
        if (StringUtils.isNotBlank(crawler)) {
            boolQuery.must(QueryBuilders.matchQuery("source", crawler));
        }
        Set<String> relationIds = new HashSet<>();
        if (StringUtils.isNotEmpty(labelIds)) {
            relationIds.add(labelIds);
        }
        if (CollectionUtils.isNotEmpty(socialCreditCodeList)) {
            relationIds.addAll(socialCreditCodeList);
        }
        if (CollectionUtils.isNotEmpty(relationIds)) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String relationId : relationIds) {
                TermQueryBuilder relationIdQuery = QueryBuilders.termQuery("labels.relationId", relationId);
                nestedBoolQueryBuilder.should(QueryBuilders.nestedQuery("labels", relationIdQuery, ScoreMode.None));
            }
            boolQuery.must(nestedBoolQueryBuilder);
        }
        if (subjectInfo.getLabelName() != null) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            TermQueryBuilder relationIdQuery = QueryBuilders.termQuery("labels.relationName", subjectInfo.getLabelName());
            nestedBoolQueryBuilder.should(QueryBuilders.nestedQuery("labels", relationIdQuery, ScoreMode.None));
            boolQuery.must(nestedBoolQueryBuilder);
        }
        if (StringUtils.isNotBlank(sourceId)) {
            boolQuery.must(QueryBuilders.termQuery("sid", sourceId));
        }
        searchSourceBuilder.query(boolQuery);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        List<DisplayInfo> list = new ArrayList<>();
        int i = 0;
        for (SearchHit hit : searchHits) {
            i++;
            String queryInfo = hit.getSourceAsString();
            DisplayInfo info = JSONUtil.toBean(queryInfo, DisplayInfo.class);
            info.setPublishDate(EsDateUtil.esFieldDateMapping(info.getPublishDate()));
            String index = hit.getIndex();
            info.setIndex(index);
            list.add(info);
        }
        IPage<DisplayInfo> pageData = new Page<>(offset, pageSize, searchResponse.getHits().getTotalHits().value);

        pageData.setRecords(list);
        return pageData;
    }

}

