package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import com.zzsn.event.entity.SubjectInfoSourceMap;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Mapper
public interface SubjectInfoSourceMapMapper extends BaseMapper<SubjectInfoSourceMap> {

    void deleteBySubjectId (@Param("subjectId") String subjectId);

    void deleteBySubjectIds (@Param("subjectIds") List<String> subjectIds);

    void deleteInfoSourceIds(@Param("subjectId") String subjectId, @Param("infoSourceIds") List<String> infoSourceIds, @Param("type")Integer type);

    List<String> selectInfoSourceBySubject(@Param("subjectIds") List<String> subjectIds, @Param("type")Integer type);
    List<String> selectInfoSourceBySubjectAndTypes(@Param("subjectIds") List<String> subjectIds, @Param("types") List<Integer> types);


    void deleteInfoSourceMapByInfoSourceIds(@Param("infoSourceIds") List<String> infoSourceIds);

    void infoSourceWeight(String subjectId, String infoSourceGroupId, String weight);

    List<String> selectSubjectIdsByGroupId(@Param("infoSourceGroupId") String infoSourceGroupId);

}
