package com.zzsn.event.enums;

import lombok.Getter;

/**
 * 货币计量单位枚举
 *
 * @author lkg
 * @date 2023/8/25
 */
@Getter
public enum SourceEnum {

    OTHER("0", "其他"),
    WEBSITE("1", "网站"),
    WEIBO("2", "微博"),
    WECHAT("3", "微信公众号"),
    DOUYIN("4", "抖音"),
    TIEBA("5", "贴吧");

    /**值*/
    private final String value;
    /**描述*/
    private final String description;


    SourceEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static String getDescription(String value){
        String description = null;
        SourceEnum[] values = SourceEnum.values();
        for (SourceEnum sourceEnum : values) {
            if (sourceEnum.value.equals(value)) {
                description = sourceEnum.description;
                break;
            }
        }
        return description;
    }
}
