package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 专题命中词关系表
 * </p>
 *
 * @author obcy
 * @since 2025-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("clb_subject_hitwords_map")
public class ClbSubjectHitwordsMap extends Model<ClbSubjectHitwordsMap> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 专题id
     */
    @TableField("subject_id")
    private String subjectId;

    /**
     * 词名
     */
    @TableField("word_name")
    private String wordName;

    /**
     * 状态
     */
    @TableField("status")
    private Integer status;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建日期
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新日期
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 0:正常 1:删除
     */
    @TableField("del_flag")
    @TableLogic
    private Boolean delFlag;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
