package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import com.zzsn.event.entity.SubjectInfoSourceMap;
import com.zzsn.event.vo.SubjectStatisticsVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date: 2021-12-09
 * @Version: V1.0
 */
@Mapper
public interface SubjectInfoSourceMapMapper extends BaseMapper<SubjectInfoSourceMap> {

    void deleteBySubjectId(@Param("subjectId") String subjectId);

    void deleteBySubjectIds(@Param("subjectIds") List<String> subjectIds);

    void infoSourceWeight(String subjectId, String infoSourceGroupId, String weight);

    List<String> selectSubjectIdsByGroupId(@Param("infoSourceGroupId") String infoSourceGroupId);

    /**
     * 专题真正绑定的信息源id集合
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> subjectRealBindInfoSourceList(@Param("subjectIds") List<String> subjectIds);


    /**
     * 专题真正绑定的信息源集合
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/7
     */
    List<SubjectStatisticsVo> subjectRealBindInfoSources(@Param("subjectIds") List<String> subjectIds);

    /**
     * 删除专题/事件和特定信息源的绑定关系
     *
     * @param subjectId     专题/事件id
     * @param infoSourceIds 信息源id
     * @param type          绑定类型
     * @author lkg
     * @date 2024/12/18
     */
    void deleteInfoSourceIds(@Param("subjectId") String subjectId, @Param("infoSourceIds") List<String> infoSourceIds, @Param("type") Integer type);

}
