package com.zzsn.event.entity;

import lombok.Data;

import java.util.Objects;

/**
 * Description:
 * 专题标签
 * @author: EDY
 * @since: 2024/3/6
 */
@Data
public class SubjectLabel {
    private String additionId;
    private String labelId;
    private String labelName;
    private String itemId;
    private String itemName;
    private String dictCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SubjectLabel that = (SubjectLabel) o;
        return Objects.equals(labelId, that.labelId) && Objects.equals(itemId, that.itemId);
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(labelId);
        result = 31 * result + Objects.hashCode(itemId);
        return result;
    }
}
