package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class SysLabelVo {
    /**
     * 主键
     */
    private String id;
    /**
     * 名称
     */
    private String name;
    /**
     * 近义词
     */
    private String synonym;
    /**
     * 说明
     */
    private String explanation;
    /**
     * 层级
     */
    private Integer level;
    /**
     * 一级主键id
     */
    private String topId;
    /**
     * 所有id
     */
    private String pathIds;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date updateTime;
    /**
     * 所属部门
     */
    private String sysOrgCode;
    /**
     * 父级节点
     */
    private String pid;
    /**
     * 是否有子节点
     */
    private String hasChild;

    /**
     * 属于哪个标签（表sys_base_label_type的主键id）
     */
    private String labelTypeId;
    /**
     * 标签类别（如企业、自定义等）
     */
    private String labelType;
    /**
     * 标签标识
     */
    private String labelMark;
    /**
     * 下级节点
     */
    private List<SysLabelVo> children;

    private Boolean isLeaf;

    /**
     * 具体标签的id集合
     */
    private List<String> labelIdList;
    private String queryParam;
    private String dataType = "";
    /**
     * 专题字段
     */
    private Integer category;

    /**
     * 词条名称
     */
    private String itemText;
    /**
     * 词条代码
     */
    private String itemValue;
    /**
     * 描述
     */
    private String description;
    /**
     * 排序值
     */
    private String sortOrder;

    /**
     * 字典id
     */
    private String dictId;

    /**唯一编码(前端回显)*/
    private String code;
    private Integer pageNo=1;
    private Integer pageSize=10;
}
