package com.zzsn.event.task;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.event.entity.InfoSource;
import com.zzsn.event.entity.SubjectInfoSourceMap;
import com.zzsn.event.entity.SubjectInfoSourceMiddleMap;
import com.zzsn.event.service.IInfoSourceService;
import com.zzsn.event.service.ISubjectInfoSourceMapService;
import com.zzsn.event.service.SubjectInfoSourceMiddleMapService;
import com.zzsn.event.util.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 待配置信息源，状态监控更新任务(和采集中心交互)
 *
 * @author lkg
 * @date 2025/5/23
 */
@Slf4j
@Component
public class WaitConfigInfoSourceTask {

    @Value("${infoSource.columnListByWait:}")
    private String columnListByWait;

    @Autowired
    private ISubjectInfoSourceMapService subjectInfoSourceMapService;
    @Autowired
    private SubjectInfoSourceMiddleMapService subjectInfoSourceMiddleMapService;
    @Autowired
    private IInfoSourceService infoSourceService;

    @Value("${scheduling.yjzxEnable:false}")
    Boolean yjzxEnable;

    /**
     * 每6小时，执行一次
     */
    @Scheduled(cron = "0 0 0/6 * * ?")
    public void syncConfig() {
        if(!yjzxEnable){
            return;
        }
        List<SubjectInfoSourceMiddleMap> waitConfigSourceList = subjectInfoSourceMiddleMapService.list(
                new LambdaQueryWrapper<SubjectInfoSourceMiddleMap>()
                        .eq(SubjectInfoSourceMiddleMap::getStatus, 0)
        );
        if (CollectionUtils.isNotEmpty(waitConfigSourceList)) {
            for (SubjectInfoSourceMiddleMap middleMap : waitConfigSourceList) {
                String subjectId = middleMap.getSubjectId();
                String waitForConfigId = middleMap.getInfoSourceId();
                JSONObject jsonObject = getColumnListByWait(waitForConfigId);
                if (jsonObject != null) {
                    middleMap.setStatus(1);
                    middleMap.setInfoSourceId(jsonObject.getString("infoSourceId"));
                    middleMap.setInfoSourceName(jsonObject.getString("infoSourceName"));
                    subjectInfoSourceMiddleMapService.updateById(middleMap);
                    List<JSONObject> columnList = JSON.parseArray(jsonObject.getString("columnList"), JSONObject.class);
                    List<SubjectInfoSourceMap> list = new ArrayList<>();
                    List<InfoSource> infoSourceList = new ArrayList<>();
                    for (JSONObject column : columnList) {
                        SubjectInfoSourceMap sms = new SubjectInfoSourceMap();
                        sms.setSubjectId(subjectId);
                        sms.setSourceId(column.getString("id"));
                        sms.setType(1);
                        list.add(sms);
                        //信息源
                        InfoSource infoSource = new InfoSource();
                        infoSource.setId(column.getString("id"));
                        infoSource.setSiteName(column.getString("columnName"));
                        infoSource.setSiteUri(column.getString("columnAddress"));
                        infoSource.setWebSiteName(jsonObject.getString("infoSourceName"));
                        infoSourceList.add(infoSource);
                    }
                    subjectInfoSourceMapService.saveBatch(list);
                    if (CollectionUtils.isNotEmpty(infoSourceList)) {
                        infoSourceService.saveOrUpdateBatch(infoSourceList);
                    }
                    log.info("待配置信息源-{}，对应已配置信息源-{}，同步更新完成",waitForConfigId, jsonObject.getString("infoSourceId"));
                }
            }
        }
    }

    private JSONObject getColumnListByWait(String waitConfigId) {
        JSONObject result = null;
        Map<String, String> variables = new HashMap<>();
        variables.put("waitConfigId", waitConfigId);
        String response = HttpUtil.doGet(columnListByWait, variables, null, "utf-8");
        JSONObject jsonObject = JSONObject.parseObject(response);
        if (jsonObject.getInteger("code") == 200) {
            result = jsonObject.getJSONObject("result");
        }
        return result;
    }
}
