package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.obs.services.model.PutObjectResult;
import com.zzsn.event.entity.EventAnalysisReport;
import com.zzsn.event.service.EventAnalysisReportService;
import com.zzsn.event.mapper.EventAnalysisReportMapper;
import com.zzsn.event.util.DocUtil;
import com.zzsn.event.util.ObsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.util.Date;
import java.util.UUID;

/**
* @author lenovo
* @description 针对表【event_analysis_report(事件分析报告)】的数据库操作Service实现
* @createDate 2024-04-12 11:13:13
*/
@Service
public class EventAnalysisReportServiceImpl extends ServiceImpl<EventAnalysisReportMapper, EventAnalysisReport> implements EventAnalysisReportService{

    @Autowired
    private ObsUtil obsUtil;

    @Override
    public void modify(String eventId, String filePath) {
        try {
            LambdaQueryWrapper<EventAnalysisReport> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(EventAnalysisReport::getEventId,eventId);
            int count = this.count(queryWrapper);
            if (count > 0) {
                this.remove(queryWrapper);
            }
            EventAnalysisReport report = new EventAnalysisReport();
            report.setEventId(eventId);
            report.setFilePath(filePath);
            InputStream inputStream = obsUtil.getObjectStream(filePath);
            String content = DocUtil.convertDocStream2Html(inputStream);
            report.setContent(content);
            this.save(report);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void edit(EventAnalysisReport report) {
        try {
            String content = report.getContent();
            String path = report.getFilePath();
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            if (StringUtils.isNotBlank(content)) {
                byte[] bytes = DocUtil.convertDocHtml2Doc(content);
                PutObjectResult putObjectResult = obsUtil.uploadFile("event/report/" +  fileName, bytes);
                String filePath = putObjectResult.getObjectKey();
                report.setFilePath(filePath);
            }
            this.updateById(report);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete(String eventId) {
        EventAnalysisReport one = this.getOne(Wrappers.<EventAnalysisReport>lambdaQuery().eq(EventAnalysisReport::getEventId, eventId));
        if (one != null) {
            String path = one.getFilePath();
            obsUtil.delFile(path);
            this.removeById(one.getId());
        }
    }
}




