package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.KeywordsType;
import com.zzsn.event.mapper.KeywordsTypeMapper;
import com.zzsn.event.service.IKeyWordsService;
import com.zzsn.event.service.IKeywordsTypeService;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.KeywordsTypeVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: 关键词类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Service
public class KeywordsTypeServiceImpl extends ServiceImpl<KeywordsTypeMapper, KeywordsType> implements IKeywordsTypeService {

    @Autowired
    private IKeyWordsService keyWordsService;
    @Override
    public void addKeywordsType(KeywordsType keywordsType) {
        if (StringUtils.isEmpty(keywordsType.getPid())) {
            keywordsType.setPid(IKeywordsTypeService.ROOT_PID_VALUE);
        } else {
            //如果当前节点父ID不为空 则设置父节点的hasChildren 为1
            KeywordsType parent = baseMapper.selectById(keywordsType.getPid());
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                baseMapper.updateById(parent);
            }
        }
        baseMapper.insert(keywordsType);
    }

    @Override
    public void updateKeywordsType(KeywordsType keywordsType) {
        KeywordsType entity = this.getById(keywordsType.getId());
        String oldPid = entity.getPid();
        String newPid = keywordsType.getPid();
        if (!oldPid.equals(newPid)) {
            updateOldParentNode(oldPid);
            if (StringUtils.isEmpty(newPid)) {
                keywordsType.setPid(IKeywordsTypeService.ROOT_PID_VALUE);
            }
            if (!IKeywordsTypeService.ROOT_PID_VALUE.equals(keywordsType.getPid())) {
                baseMapper.updateTreeNodeStatus(keywordsType.getPid(), IKeywordsTypeService.HASCHILD);
            }
        }
        baseMapper.updateById(keywordsType);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteKeywordsType(String id) {
        //查询选中节点下所有子节点一并删除
        id = this.queryTreeChildIds(id);
        if (id.contains(",")) {
            StringBuilder sb = new StringBuilder();
            String[] idArr = id.split(",");
            for (String idVal : idArr) {
                if (idVal != null) {
                    KeywordsType keywordsType = this.getById(idVal);
                    String pidVal = keywordsType.getPid();
                    //查询此节点上一级是否还有其他子节点
                    List<KeywordsType> dataList = baseMapper.selectList(new QueryWrapper<KeywordsType>().eq("pid", pidVal).notIn("id", Arrays.asList(idArr)));
                    if ((dataList == null || dataList.size() == 0) && !Arrays.asList(idArr).contains(pidVal)
                            && !sb.toString().contains(pidVal)) {
                        //如果当前节点原本有子节点 现在木有了，更新状态
                        sb.append(pidVal).append(",");
                    }
                }
            }
            //批量删除节点
            baseMapper.deleteBatchIds(Arrays.asList(idArr));
            //修改已无子节点的标识
            String[] pidArr = sb.toString().split(",");
            for (String pid : pidArr) {
                this.updateOldParentNode(pid);
            }
        } else {
            KeywordsType keywordsType = this.getById(id);
            updateOldParentNode(keywordsType.getPid());
            baseMapper.deleteById(id);
        }

    }


    @Override
    public List<KeywordsTypeVo> allList(Boolean contain, String subjectId,String bindingType) {
        List<KeywordsTypeVo> allList = new ArrayList<>();
        KeywordsTypeVo infoSourceTypeVo = new KeywordsTypeVo();
        infoSourceTypeVo.setId("0");
        infoSourceTypeVo.setTypeName("所有");
        infoSourceTypeVo.setPid("0");
        infoSourceTypeVo.setHasChild("1");
        List<KeywordsTypeVo> list = baseMapper.listAll();
        List<KeyWordsPage> keyWordsPageList = keyWordsService.listByTypeIdList(
                list.stream().map(KeywordsTypeVo::getId).collect(Collectors.toList()), subjectId, 1,bindingType);
        if (Boolean.TRUE.equals(contain)) {
            Map<String, List<KeyWordsPage>> map = keyWordsPageList.stream().collect(Collectors.groupingBy(KeyWordsPage::getTypeId));
            for (int i = 0; i < list.size(); i++) {
                KeywordsTypeVo groupTypeVo1 = list.get(i);
                if (StringUtils.isEmpty(groupTypeVo1.getHasChild())) {
                    List<KeyWordsPage> pageList = map.get(groupTypeVo1.getId());
                    if (pageList != null && !pageList.isEmpty()) {
                        for (KeyWordsPage keyWordsPage : pageList) {
                            KeywordsTypeVo keywordsTypeVo = new KeywordsTypeVo();
                            keywordsTypeVo.setId(keyWordsPage.getId());
                            keywordsTypeVo.setHasChild(null);
                            keywordsTypeVo.setTypeName(keyWordsPage.getWordsName());
                            keywordsTypeVo.setPid(groupTypeVo1.getId());
                            keywordsTypeVo.setIsKeyWords(true);
                            list.add(keywordsTypeVo);
                        }
                    }
                }
            }
        }
        List<KeywordsTypeVo> typeList = getTreeList(list);
        infoSourceTypeVo.setChildren(typeList);
        allList.add(infoSourceTypeVo);
        return allList;
    }

    @Override
    public List<KeywordsTypeVo> listByParentIdAndSubjectId(String subjectId, String parentId) {
        if (!parentId.equals("0")) {
            KeywordsType parent = this.getById(parentId);
            List<KeywordsTypeVo> finalList = new ArrayList<>();
            if (StringUtils.isEmpty(parent.getHasChild()) || "0".equals(parent.getHasChild())) {
                List<KeyWordsPage> pageList = keyWordsService.listByTypeIdList(Collections.singletonList(parentId), subjectId, 1,null);
                if (pageList != null && !pageList.isEmpty()) {
                    for (KeyWordsPage keyWordsPage : pageList) {
                        KeywordsTypeVo keywordsTypeVo = new KeywordsTypeVo();
                        keywordsTypeVo.setId(keyWordsPage.getId());
                        keywordsTypeVo.setHasChild(null);
                        keywordsTypeVo.setTypeName(keyWordsPage.getWordsName());
                        keywordsTypeVo.setPid(parentId);
                        keywordsTypeVo.setIsKeyWords(true);
                        finalList.add(keywordsTypeVo);
                    }
                }
                return finalList;
            }

        }
        KeywordsTypeVo infoSourceTypeVo = new KeywordsTypeVo();
        infoSourceTypeVo.setId("0");
        infoSourceTypeVo.setTypeName("所有");
        infoSourceTypeVo.setPid("0");
        infoSourceTypeVo.setHasChild("1");
        List<KeywordsTypeVo> list = baseMapper.listAll();
        Map<String, List<KeywordsTypeVo>> pidMap = list.stream().collect(Collectors.groupingBy(KeywordsTypeVo::getPid));
        List<KeywordsTypeVo> firstGroup = list.stream().filter(item -> item.getPid().equals(parentId)).collect(Collectors.toList());


        for (KeywordsTypeVo keywordsTypeVo : firstGroup) {
            if (StringUtils.isEmpty(keywordsTypeVo.getHasChild()) || "0".equals(keywordsTypeVo.getHasChild())) {
                List<String> oneInList = new ArrayList<>();
                oneInList.add(keywordsTypeVo.getId());
                //tips 当数据量大 最好不用列表
                Integer count = keyWordsService.countByTypeAndIdList(oneInList,subjectId);
                keywordsTypeVo.setChildrenCount(count);
            } else {
                //获取每个下面最后一级分类列表
                List<KeywordsTypeVo> singleList = new ArrayList<>(1);
                singleList.add(keywordsTypeVo);
                List<KeywordsTypeVo> finalGradeList = new ArrayList<>();
                getFinalIdListInMap(singleList, pidMap, finalGradeList);
                List<String> finalIdList = finalGradeList.stream().map(KeywordsTypeVo::getId).collect(Collectors.toList());
                if (!finalIdList.isEmpty()) {
                    Integer count = keyWordsService.countByTypeAndIdList(finalIdList, subjectId);
                    keywordsTypeVo.setChildrenCount(count);
                } else {
                    keywordsTypeVo.setChildrenCount(0);
                }
            }
        }


        return firstGroup;
    }

    private void getFinalIdListInMap(List<KeywordsTypeVo> groupTypeVoList, Map<String, List<KeywordsTypeVo>> pidMap, List<KeywordsTypeVo> finalGroupTypeVoList) {
        List<KeywordsTypeVo> nextGradeNotFinalList = new ArrayList<>();
        for (KeywordsTypeVo subjectTypeVo : groupTypeVoList) {
            List<KeywordsTypeVo> tempList = pidMap.get(subjectTypeVo.getId());
            if (tempList != null) {
                List<KeywordsTypeVo> finalList = tempList.stream()
                        .filter(item -> null == item.getHasChild() && StringUtils.isEmpty(item.getHasChild()) || "0".equals(item.getHasChild()))
                        .collect(Collectors.toList());
                finalGroupTypeVoList.addAll(finalList);
                tempList.removeAll(finalList);
                nextGradeNotFinalList.addAll(tempList);
            }

        }
        if (nextGradeNotFinalList.isEmpty()) {
            return;
        }
        getFinalIdListInMap(nextGradeNotFinalList, pidMap, finalGroupTypeVoList);
    }


    //获取授权用户业务分类信息，树状结构
    private List<KeywordsTypeVo> getTreeList(List<KeywordsTypeVo> authTypeList) {
        List<KeywordsTypeVo> topList = new ArrayList<>();
        authTypeList.forEach(e -> {
            if ("0".equals(e.getPid())) {
                topList.add(e);
            }
        });
        for (KeywordsTypeVo infoSourceTypeVo : topList) {
            setChildren(infoSourceTypeVo, authTypeList);
        }
        return topList;
    }

    //递归获取树形结构数据
    private void setChildren(KeywordsTypeVo parent, List<KeywordsTypeVo> list) {
        Set<KeywordsTypeVo> children = getChildren(list, parent.getId());
        parent.setChildren(new ArrayList<>(children));
        for (KeywordsTypeVo infoSourceTypeVo : children) {
            setChildren(infoSourceTypeVo, list);
        }
    }

    private Set<KeywordsTypeVo> getChildren(List<KeywordsTypeVo> list, String id) {
        Set<KeywordsTypeVo> children = new HashSet<>();
        for (KeywordsTypeVo infoSourceTypeVo : list) {
            if (infoSourceTypeVo.getPid().equals(id)) {
                children.add(infoSourceTypeVo);
            }
        }
        return children;
    }


    /**
     * 根据所传pid查询旧的父级节点的子节点并修改相应状态值
     *
     * @param pid
     */
    private void updateOldParentNode(String pid) {
        if (!IKeywordsTypeService.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(new QueryWrapper<KeywordsType>().eq("pid", pid));
            if (count == null || count <= 1) {
                baseMapper.updateTreeNodeStatus(pid, IKeywordsTypeService.NOCHILD);
            }
        }
    }

    /**
     * 根据id查询所有子节点id
     *
     * @param ids
     * @return
     */
    private String queryTreeChildIds(String ids) {
        //获取id数组
        String[] idArr = ids.split(",");
        StringBuffer sb = new StringBuffer();
        for (String pidVal : idArr) {
            if (pidVal != null && (!sb.toString().contains(pidVal))) {
                    if (sb.toString().length() > 0) {
                        sb.append(",");
                    }
                    sb.append(pidVal);
                    this.getTreeChildIds(pidVal, sb);

            }
        }
        return sb.toString();
    }

    /**
     * 递归查询所有子节点
     *
     * @param pidVal
     * @param sb
     * @return
     */
    private StringBuffer getTreeChildIds(String pidVal, StringBuffer sb) {
        List<KeywordsType> dataList = baseMapper.selectList(new QueryWrapper<KeywordsType>().eq("pid", pidVal));
        if (dataList != null && dataList.size() > 0) {
            for (KeywordsType tree : dataList) {
                if (!sb.toString().contains(tree.getId())) {
                    sb.append(",").append(tree.getId());
                }
                this.getTreeChildIds(tree.getId(), sb);
            }
        }
        return sb;
    }

}
