package com.zzsn.event.feign.api;

import cn.hutool.core.lang.tree.Tree;
import com.zzsn.event.constant.Result;
import com.zzsn.event.feign.entity.SysDictItem;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "jeecg-system")
public interface RemoteSystemService {

    //feign调用测试、查询数据字典值
    @GetMapping("/sys/dictItem/remoteList")
    String sysDictItemList(@RequestBody SysDictItem sysDictItem, @RequestParam("pageSize") Integer pageSize, @RequestParam("pageNo") Integer pageNo);

    @GetMapping("/sys/dictType/treeListContainsDict")
    Result<List<Tree<String>>> treeListContainsDict();
}
