package com.zzsn.event.controller.common;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.entity.KeywordConf;
import com.zzsn.event.entity.KeywordsType;
import com.zzsn.event.service.IKeyWordsService;
import com.zzsn.event.service.IKeywordsTypeService;
import com.zzsn.event.service.KeywordConfService;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.KeywordsTypeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 关键词
 *
 * @author lkg
 * @date 2024/12/24
 */
@RestController
@RequestMapping("/keyword")
public class KeywordController {

    @Autowired
    private IKeywordsTypeService keywordsTypeService;
    @Autowired
    private IKeyWordsService keyWordsService;
    @Autowired
    private KeywordConfService keywordConfService;

    /**
     * 通过父级id列表查询
     *
     * @param subjectId 专题id
     * @param parentId  上级id
     * @author lkg
     * @date 2024/12/24
     */
    @GetMapping(value = "/type/listByParentId")
    public Result<?> listByParentId(@RequestParam(name = "subjectId", defaultValue = "0") String subjectId,
                                    @RequestParam(name = "parentId", defaultValue = "0") String parentId) {
        List<KeywordsTypeVo> allList = keywordsTypeService.listByParentIdAndSubjectId(subjectId, parentId);
        return Result.OK(allList);
    }

    /**
     * 词组分类列表
     *
     * @param contain
     * @param subjectId
     * @param bindingType
     * @author lkg
     * @date 2024/12/24
     */
    @GetMapping(value = "/type/rootListNoPage")
    public Result<?> queryPageListNoPage(@RequestParam(name = "contain", defaultValue = "false") Boolean contain,
                                         @RequestParam(name = "subjectId", defaultValue = "0") String subjectId,
                                         @RequestParam(name = "bindingType", required = false) String bindingType) {
        List<KeywordsTypeVo> allList = keywordsTypeService.allList(contain, subjectId, bindingType);
        return Result.OK(allList);
    }

    /**
     * 新增分类
     *
     * @param keywordsType 分类信息
     * @author lkg
     * @date 2024/12/24
     */
    @PostMapping(value = "/type/add")
    public Result<?> add(@RequestBody KeywordsType keywordsType) {
        keywordsTypeService.addKeywordsType(keywordsType);
        return Result.OK();
    }

    /*
     * 编辑
     *
     * @param keywordsType 分类信息
     * @author lkg
     * @date 2024/12/24
     */
    @PostMapping(value = "/type/edit")
    public Result<?> edit(@RequestBody KeywordsType keywordsType) {
        keywordsTypeService.updateKeywordsType(keywordsType);
        return Result.OK();
    }

    /**
     * 通过id删除
     *
     * @param id 分类id
     * @return
     */
    @GetMapping(value = "/type/delete")
    public Result<?> typeDelete(@RequestParam(name = "id") String id) {
        keywordsTypeService.deleteKeywordsType(id);
        return Result.OK();
    }


    /**
     * 关键词组分页列表查询
     *
     * @param keyWords
     * @param pageNo
     * @param pageSize
     * @param keyWordsTypeId
     * @param bindingType
     * @param search
     * @param subjectId
     * @author lkg
     * @date 2024/12/24
     */
    @GetMapping(value = "/listByTypeId")
    public Result<?> queryPageListByTypeId(KeyWords keyWords,
                                           @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                           @RequestParam(name = "keyWordsTypeId", defaultValue = "0") String keyWordsTypeId,
                                           @RequestParam(name = "bindingType", required = false) String bindingType,
                                           @RequestParam(name = "search", defaultValue = "false") Boolean search,
                                           @RequestParam(name = "subjectId", defaultValue = "0") String subjectId) {
        IPage<KeyWordsPage> pageList = keyWordsService.pageByTypeId(keyWords, pageNo, pageSize, keyWordsTypeId, search, subjectId, bindingType);
        return Result.OK(pageList);
    }

    /**
     * 新增关键词
     *
     * @param keyWordsPage
     * @author lkg
     * @date 2024/12/24
     */
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody KeyWordsPage keyWordsPage) {
        JSONObject jsonObject = keyWordsService.saveMain(keyWordsPage);
        if (Boolean.FALSE.equals(jsonObject.getBoolean("result"))) {
            return Result.FAIL(500, jsonObject.getString("message"));
        } else {
            return Result.OK(jsonObject.get("keyWord"));
        }
    }

    /**
     * 编辑
     *
     * @param keyWordsPage
     * @return
     */
    @PostMapping(value = "/edit")
    public Result<?> edit(@RequestBody KeyWordsPage keyWordsPage) {
        keyWordsService.updateMain(keyWordsPage);
        return Result.OK();
    }

    /**
     * 通过id删除
     *
     * @param id 词组id
     * @return
     */
    @GetMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id") String id) {
        keyWordsService.deleteMain(id);
        return Result.OK();
    }

    /**
     * 批量删除
     *
     * @param ids 词组id，多个逗号拼接
     * @return
     */
    @GetMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids") String ids) {
        keyWordsService.deleteMain(ids);
        return Result.OK();
    }

    /**
     * 通过id查询
     *
     * @param id 词组id
     * @return
     */
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id") String id) {
        KeyWordsPage keyWords = keyWordsService.getKeyWordsById(id);
        return Result.OK(keyWords);
    }

    /**
     * 添加关键词过滤配置
     *
     * @param keywordConf 过滤词信息
     * @author lkg
     * @date 2025/7/28
     */
    @PostMapping("/conf/add")
    public Result<?> configAdd(@RequestBody List<KeywordConf> keywordConf){
        keywordConfService.saveBatch(keywordConf);
        return Result.OK();
    }
}
