package com.zzsn.event.config.interceptor;

import cn.hutool.core.net.URLDecoder;
import com.alibaba.fastjson2.JSON;
import com.zzsn.event.constant.Result;
import com.zzsn.event.util.RequestUtil;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

/**
 * 授权拦截
 *
 * @author lkg
 * @date 2023/4/12
 */
@Slf4j
public class LoginInterceptor implements HandlerInterceptor {

    public final static String LOGIN_USER_HEADER = "loginUser";

    private final String profiles;

    public LoginInterceptor(String profiles) {
        this.profiles = profiles;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        String userInfo = URLDecoder.decode(request.getHeader(LOGIN_USER_HEADER), StandardCharsets.UTF_8);
        log.debug("当前登录用户信息:{}", userInfo);
        if (StringUtils.isBlank(userInfo)) {
            returnJson(response, JSON.toJSONString(Result.FAIL(401, "Token失效，请重新登录")));
            return false;
        }
        UserVo userVo = JSON.parseObject(userInfo, UserVo.class);
        if("yjzx".equals(profiles)){
            userVo.setTenant(RequestUtil.getTenantByRequest(request));
        }
        UserUtil.setLoginUser(userVo);
        return true;
    }

    @Override
    public void postHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, ModelAndView modelAndView) {

    }

    @Override
    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) {
        UserUtil.removeUser();
    }

    private void returnJson(HttpServletResponse response, String json) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        try (PrintWriter writer = response.getWriter()) {
            writer.println(json);
        } catch (Exception ignored) {
        }
    }

}
