package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author obcy
 * @since 2024-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("clb_subject_model_detail_task")
public class ClbSubjectModelDetailTask extends Model<ClbSubjectModelDetailTask> {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 专题id
     */
    @TableField("subject_id")
    private String subjectId;

    /**
     * 本次任务使用的模型ids
     */
    @TableField("model_ids")
    private String modelIds;

    /**
     * 处理到的时间节点
     */
    @TableField("detail_to_time")
    private Date detailToTime;
    /**
     * 处理到的时间节点
     */
    @TableField("detail_from_time")
    private Date detailFromTime;
    /**
     * 任务状态：0创建，1正在处理，2处理完毕，3被中断
     */
    @TableField("task_status")
    private Integer taskStatus;

    /**
     * 开始处理时间
     */
    @TableField("start_time")
    private Date startTime;

    /**
     * 中断时间
     */
    @TableField("break_time")
    private Date breakTime;

    /**
     * 完成时间
     */
    @TableField("finish_time")
    private Date finishTime;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 任务模型参数
     */
    @TableField("task_param")
    private String taskParam;
    /**
     * 任务配置参数
     */
    @TableField("all_param")
    private String allParam;
    /**
     * 任务参数
     */
    @TableField("task_code")
    private String taskCode;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
