package com.zzsn.event.vo.es;

import com.zzsn.event.vo.LabelInfo;
import lombok.Data;

import java.util.List;

@Data
public class DisplayInfo {
    //说明：...Raw 表示原文，即原语言
    //作者
    private String author;
    private String authorRaw;
    //正文
    private String content;
    private String contentRaw;
    //带标签正文
    private String contentWithTag;
    private String contentWithTagRaw;
    //入库时间
    private String createDate;
    //信息id
    private String id;
    //信息来源id(信息源或者关键词)
    private String sid;
    //语言
    private String lang;
    private String langRaw;
    //来源（信息来源）
    private String origin;
    private String originRaw;
    //发布时间
    private String publishDate;
    //原始时间（网页上，没有解析之前的时间）
    private String originalTime;
    //发布地址
    private String sourceAddress;
    //摘要
    private String summary;
    private String summaryRaw;
    //关键词
    private String keyWords;
    //标题
    private String title;
    private String titleRaw;
    //采集来源（如通用、定制、微信公众号等）
    private String source;
    //附加字段
    private String type;
    //标签信息
    private List<Label> labels;
    //模型打分信息
    private List<ModelScore> modelScores;
    //视频下载链接
    private String downLoadUrl;
    //视频链接（原链接 网页版）
    private String videoUrl;
    //视频链接（原链接 手机版）
    private String videoPhoneUrl;
    //视频时长
    private Long videoTime;
    //视频第一帧图片
    private String videoImg;
    //自定义标签
    private List<String> customLabel;
    private Double score;
    //专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例)
    private Integer classificationType;
    //置顶排位(默认为0)
    private Integer topNum;
    //删除标记(1:删除；0:保留)
    private Integer deleteFlag;
    private String subjectId;
    private String subjectName;
    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;
    //阅读数
    private Long readNum = 0L;
    //是否收藏
    private boolean ynCollect = false;
    //重复id
    private String repeatId;
    //（1：主条目  0：非主条目）
    private String flag;
    //关联的主条目id
    private String masterEntryId;
    //原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系)
    private String originalId;
    //快照地址
    private String screenShotImg;
    //资讯更新时间
    private String updateDate;
    //信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它）
    private String infoSourceType;
    //数据类型 qbyw:情报要闻 qbnc:情报内参
    private String dataType;
    //abi报表地址
    private String abiUrl;
    //abi报表id
    private String abiId;
    //栏目code列表
    private List<String> programaIds;
    //数据库code列表
    private List<String> databaseIds;
    //是否风险
    private Integer isRisk;
    //风险类型
    private List<String> riskTypes;
    //标签集合
    private List<LabelInfo> labelInfos;
    //是否为资讯(true:资讯  false:附件类)
    private Boolean ynArticle = true;
    //法规号
    private String contentNo;


    //来源  （政策发文机关）
    private String organ;
    //政策文件分类
    private String topicClassification;
    //发文字号
    private String issuedNumber;
    //成文时间
    private String writtenDate;
    //数据所在的索引名称
    private String index;
    /**
     * 是否是主条目,0为非主条目，1为主条目
     */
    private Integer ismain;
}
