package com.zzsn.event.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.*;
import com.zzsn.event.entity.arrange.ClbModelArrange;
import com.zzsn.event.enums.BindTypeEnum;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.enums.SourceTypeEnum;
import com.zzsn.event.es.EsService;
import com.zzsn.event.mapper.SubjectMapper;
import com.zzsn.event.permit.ParamAop;
import com.zzsn.event.permit.UQueryEntity;
import com.zzsn.event.service.*;
import com.zzsn.event.util.*;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.user.AuthUtil;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @Description: 专题表
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Service
@Slf4j
public class SubjectServiceImpl extends ServiceImpl<SubjectMapper, Subject> implements SubjectService {
    @Autowired
    private InformationService informationService;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private ISubjectTypeService subjectTypeService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ISubjectTypeMapService subjectTypeMapService;
    @Autowired
    private IProjectSubjectMapService projectSubjectMapService;
    @Autowired
    private ISubjectSearchEnginesMapService subjectSearchEnginesMapService;
    @Autowired
    private ISubjectKeywordsMapService subjectKeywordsMapService;
    @Autowired
    private ISubjectInfoSourceMapService subjectInfoSourceMapService;
    @Autowired
    private ISubjectModelMapService subjectModelMapService;
    @Autowired
    private IInfoSourceService infoSourceService;
    @Autowired
    private IKeyWordsService keyWordsService;
    @Autowired
    private ClbSubjectModelDetailTaskService subjectModelDetailTaskService;
    @Autowired
    private IAlgorithmModelService modelService;
    @Autowired
    private ClbModelArrangeSubjectMapService clbModelArrangeSubjectMapService;
    @Autowired
    private IKeyWordsService iKeyWordsService;
    @Autowired
    private IClbModelArrangeService clbModelArrangeService;
    @Autowired
    private ConfigurationMessageService configurationMessageService;
    @Autowired
    private ScoreModelService scoreModelService;
    @Autowired
    private InfoSourceGroupService infoSourceGroupService;
    @Autowired
    private ISubjectInfoSourceMapService iSubjectInfoSourceMapService;
    @Autowired
    private ParamAop paramAop;
    @Autowired
    private EsService esService;
    @Value("${python.subjectProcessorUrl}")
    private String subjectProcessorUrl;
    @Value("${clb.subject.default.processing.advanceMonth}")
    private Integer defaultAdvanceMonth;

    //专题信息数量本地缓存
    LocalCache<String, Map<String,StatisticVO>> numLocalCache = new LocalCache<>(60 * 1000);


    @Override
    public Page<SubjectPage> pageList(SubjectCondition subjectCondition, Integer pageNo, Integer pageSize) {
        //查询类别id的所有明细id
        List<String> typeIds = new ArrayList<>();
        String subjectTypeId = subjectCondition.getSubjectTypeId();
        if (StringUtils.isNotEmpty(subjectTypeId) && !"0".equals(subjectTypeId)) {
            typeIds = subjectTypeService.belowIdList(subjectTypeId, 1);
        }
        subjectCondition.setTypeIds(typeIds);
        Page<SubjectPage> page = new Page<>(pageNo, pageSize);
        Page<SubjectPage> pageList = baseMapper.pageList(subjectCondition, page);
        List<SubjectPage> records = pageList.getRecords();
        if (CollUtil.isNotEmpty(records)) {
            List<String> idList = records.stream().map(SubjectPage::getId).collect(Collectors.toList());

            //按专题分组，统计绑定关键词组的数量
            Map<String, Integer> keyWordsNumMap = commonService.bindKeyWordsCountList(idList).stream().collect(Collectors.toMap(SubjectPage::getId, SubjectPage::getKeyWordsNum));
            //按专题分组，统计绑定信息源的数量
            //Map<String, List<SubjectSourceVO>> collect = commonService.bindSourceList(idList).stream().collect(Collectors.groupingBy(SubjectSourceVO::getSubjectId));
            Map<String, Integer> sourceCountMap = commonService.bindSourceCount(idList);
//            Map<String, Integer> infoSourceNumMap = new HashMap<>();
//            for (Map.Entry<String, List<SubjectSourceVO>> entry : collect.entrySet()) {
//                String subjectId = entry.getKey();
//                List<SubjectSourceVO> value = entry.getValue();
//                infoSourceNumMap.put(subjectId, value.size());
//            }
            //查询每个专题绑定的信息源数量及关键词数量
            for (SubjectPage subjectPage1 : records) {
                int keyWordsNum = null == keyWordsNumMap.get(subjectPage1.getId()) ? 0 : keyWordsNumMap.get(subjectPage1.getId());
                int infoSourceNum = null == sourceCountMap.get(subjectPage1.getId()) ? 0 : sourceCountMap.get(subjectPage1.getId());
                subjectPage1.setInfoSourceNum(infoSourceNum);
                subjectPage1.setKeyWordsNum(keyWordsNum);
            }

            //查询绑定的流程
            List<ClbModelArrange> clbModelArranges = clbModelArrangeService.listBySubjectIds(idList);
            if (CollectionUtil.isNotEmpty(clbModelArranges)) {
                clbModelArranges.forEach(e -> e.setType(SourceTypeEnum.getValueNameByValue(e.getType())));
                Map<String, List<ClbModelArrange>> collect = clbModelArranges.stream().collect(Collectors.groupingBy(ClbModelArrange::getSubjectId));
                records.forEach(e -> {
                    e.setClbModelArranges(collect.get(e.getId()));
                });
            }
        }
        return pageList;
    }

    @Override
    public Page<SubjectPageVO> pageList_new(SubjectCondition subjectCondition, Integer pageNo, Integer pageSize) {
        //查询类别id的所有明细id
        List<String> typeIds = new ArrayList<>();
        String subjectTypeId = subjectCondition.getSubjectTypeId();
        if (StringUtils.isNotEmpty(subjectTypeId) && !"0".equals(subjectTypeId)) {
            typeIds = subjectTypeService.belowIdList(subjectTypeId, 1);
        }
        subjectCondition.setTypeIds(typeIds);
        Page<SubjectPageVO> page = new Page<>(pageNo, pageSize);
        Page<SubjectPageVO> pageList = baseMapper.pageList_new(page,subjectCondition, AuthUtil.getAuthUserId());
        List<SubjectPageVO> records = pageList.getRecords();
        if (CollUtil.isNotEmpty(records)) {
            List<String> idList = records.stream().map(SubjectPageVO::getId).collect(Collectors.toList());
            //查询绑定的流程
            List<ClbModelArrange> clbModelArranges = clbModelArrangeService.listBySubjectIds(idList);
            if (CollectionUtil.isNotEmpty(clbModelArranges)) {
                clbModelArranges.forEach(e -> e.setType(SourceTypeEnum.getValueNameByValue(e.getType())));
                Map<String, List<ClbModelArrange>> collect = clbModelArranges.stream().collect(Collectors.groupingBy(ClbModelArrange::getSubjectId));
                records.forEach(e -> e.setClbModelArranges(collect.get(e.getId())));
            }
            Optional<SubjectPageVO> any = records.stream().filter(f -> StrUtil.isNotBlank(f.getDataScope())).findAny();
            if (any.isPresent()) {
                int count = infoSourceService.count();
                records.forEach(e -> {
                    if (StrUtil.isNotBlank(e.getDataScope()) && e.getDataScope().contains("1")) {
                        e.setBindSourceNum(count);
                    }
                });

            }
        }
        return pageList;
    }

    @Override
    public List<SubjectStatisticInfo> statisticInfo(List<String> subjectIds) {
        List<SubjectStatisticInfo> list = new ArrayList<>();
        //按专题分组，统计绑定关键词组的数量
        Map<String, Integer> keyWordsNumMap = commonService.bindKeyWordsCountList(subjectIds).stream().collect(Collectors.toMap(SubjectPage::getId, SubjectPage::getKeyWordsNum));
        //按专题分组，统计绑定信息源的数量
        Map<String, Integer> sourceCountMap = commonService.bindSourceCount(subjectIds);
        //绑定全部信息源的专题
        Map<String, Integer> infoSourceNumMap = new HashMap<>();
        List<Subject> subjects = baseMapper.selectBatchIds(subjectIds);
        Optional<Subject> any = subjects.stream().filter(f -> StrUtil.isNotBlank(f.getDataScope())).findAny();
        if (any.isPresent()) {
            int count = infoSourceService.count();
            subjects.forEach(e -> {
                if (StrUtil.isNotBlank(e.getDataScope()) && e.getDataScope().contains("1")) {
                    infoSourceNumMap.put(e.getId(), count);
                }
            });
        }
        for (Subject subject : subjects) {
            String subjectId = subject.getId();
            String estimateStatus = subject.getEstimateStatus();
            SubjectStatisticInfo subjectStatisticInfo = new SubjectStatisticInfo();
            subjectStatisticInfo.setSubjectId(subjectId);
            if (infoSourceNumMap.containsKey(subjectId)) {
                subjectStatisticInfo.setBindSourceNum(infoSourceNumMap.get(subjectId));
            } else {
                subjectStatisticInfo.setBindSourceNum(sourceCountMap.get(subjectId) == null ? 0 : sourceCountMap.get(subjectId));
            }
            subjectStatisticInfo.setBindKeywordNum(keyWordsNumMap.get(subjectId) == null ? 0 : keyWordsNumMap.get(subjectId));
            StatisticVO totalAndLatestDate;
            StatisticVO unCheckNum;
            StatisticVO modelNum;
            List<String> subjectIdList = new ArrayList<>();
            subjectIdList.add(subjectId);
            if (!(StringUtils.isEmpty(estimateStatus) || "已完成".equals(estimateStatus))) {
                totalAndLatestDate = esService.subjectStatisticInfo(subjectIdList, null, null, 1).get(0);
                unCheckNum = esService.subjectStatisticInfo(subjectIdList, 2, null, null).get(0);
                modelNum = esService.subjectStatisticInfo(subjectIdList, null, 1, null).get(0);
            } else {
                if (numLocalCache.get(subjectId) == null) {
                    totalAndLatestDate = esService.subjectStatisticInfo(subjectIdList, null, null, 1).get(0);
                    unCheckNum = esService.subjectStatisticInfo(subjectIdList, 2, null, null).get(0);
                    modelNum = esService.subjectStatisticInfo(subjectIdList, null, 1, null).get(0);
                    Map<String, StatisticVO> numMap = new HashMap<>();
                    numMap.put("totalAndLatestDate", totalAndLatestDate);
                    numMap.put("unCheckNum", unCheckNum);
                    numMap.put("modelNum", modelNum);
                    numLocalCache.put(subjectId, numMap);
                } else {
                    Map<String, StatisticVO> numMap = numLocalCache.get(subjectId);
                    totalAndLatestDate = numMap.get("totalAndLatestDate");
                    unCheckNum = numMap.get("unCheckNum");
                    modelNum = numMap.get("modelNum");
                }
            }
            subjectStatisticInfo.setTotalNum(totalAndLatestDate.getCount());
            subjectStatisticInfo.setLatestDataDate(totalAndLatestDate.getPublishDate());
            subjectStatisticInfo.setUnCheckNum(unCheckNum.getCount());
            subjectStatisticInfo.setModelNum(modelNum.getCount());
            list.add(subjectStatisticInfo);
        }
        /*//专题统计信息-总数量、最新资讯日期
        List<StatisticVO> totalAndLatestDateList = esService.subjectStatisticInfo(subjectIds, null,null, 1);
        Map<String,StatisticVO> totalAndLatestDateMap = totalAndLatestDateList.stream().collect(Collectors.toMap(StatisticVO::getSubjectId, e -> e));
        //专题统计信息-待审核数量
        List<StatisticVO> unCheckNumList = esService.subjectStatisticInfo(subjectIds, 2,null, null);
        Map<String, StatisticVO> unCheckNumMap = unCheckNumList.stream().collect(Collectors.toMap(StatisticVO::getSubjectId, e->e));
        //专题统计信息-模型推荐数量
        List<StatisticVO> modelNumList = esService.subjectStatisticInfo(subjectIds, null,1, null);
        Map<String, StatisticVO> modelNumMap = modelNumList.stream().collect(Collectors.toMap(StatisticVO::getSubjectId, e->e));
        for (String subjectId : subjectIds) {
            SubjectStatisticInfo subjectStatisticInfo = new SubjectStatisticInfo();
            subjectStatisticInfo.setSubjectId(subjectId);
            subjectStatisticInfo.setTotalNum(totalAndLatestDateMap.get(subjectId).getCount());
            subjectStatisticInfo.setLatestDataDate(totalAndLatestDateMap.get(subjectId).getPublishDate());
            subjectStatisticInfo.setUnCheckNum(unCheckNumMap.get(subjectId).getCount());
            subjectStatisticInfo.setModelNum(modelNumMap.get(subjectId).getCount());
            if (infoSourceNumMap.containsKey(subjectId)) {
                subjectStatisticInfo.setBindSourceNum(infoSourceNumMap.get(subjectId));
            } else {
                subjectStatisticInfo.setBindSourceNum(sourceCountMap.get(subjectId) == null ? 0 : sourceCountMap.get(subjectId));
            }
            subjectStatisticInfo.setBindKeywordNum(keyWordsNumMap.get(subjectId) == null ? 0 : keyWordsNumMap.get(subjectId));
            list.add(subjectStatisticInfo);
        }*/
        return list;
    }

    @Override
    public SubjectPage getInfo(String subjectId) {
        return baseMapper.getInfo(subjectId);
    }

    @Override
    public Page<SubjectPage> researchCenterPageList(SubjectCondition subjectCondition, Integer pageNo, Integer pageSize,String flagCode,HttpServletRequest request,String username) {
        Integer facePublic = subjectCondition.getFacePublic();
        Page<SubjectPage> page = new Page<>(pageNo, pageSize);
        if (facePublic != null && facePublic == 1) {
            //公开的添加数据权限-查询拥有权限的公开专题以及个人创建的公开专题
            String sql = "";
            if(StringUtils.isNotBlank(flagCode)){
                String accesstoken = request.getHeader("Accesstoken");
                String userId = TokenUtil.verifyToken(accesstoken);
                UQueryEntity queryEntity = new UQueryEntity();
                queryEntity.setUserId(userId);
                queryEntity.setFlagCode(flagCode);
                queryEntity = paramAop.startArs(queryEntity,accesstoken,subjectCondition.getEnvironment());
                String sqlStr = queryEntity.getSql();
                if(sqlStr.contains("()")){
                    sqlStr = sqlStr.replace("()","(1=2)");
                }
                if(sqlStr.contains("id")){
                    sqlStr = sqlStr.replace("id","d.id");
                }
                sql = sqlStr;
                log.info("researchCenterPageList sql:{}",sql);
            }
            log.info("researchCenterPageList username:{},environment:{},sql:{}",username,subjectCondition.getEnvironment(),sql);
            page = baseMapper.researchCenterFacePageList(subjectCondition, page,sql,username);
        } else {
            //查询类别id的所有明细id
            List<String> typeIds = new ArrayList<>();
            String subjectTypeId = subjectCondition.getSubjectTypeId();
            if (StringUtils.isNotEmpty(subjectTypeId) && !"0".equals(subjectTypeId)) {
                typeIds = subjectTypeService.researchCenterBelowIdList(subjectTypeId, 1);
            }
            subjectCondition.setTypeIds(typeIds);
            UserVo loginUser = UserUtil.getLoginUser();
            subjectCondition.setUsername(loginUser.getUsername());
            page = baseMapper.researchCenterPageList(subjectCondition, page);
        }
        return page;
    }

    @Override
    public Page<Node> visiblePageList(String username, Integer type, String subjectName,Integer subjectType, Integer pageNo, Integer pageSize, String environment,HttpServletRequest request,String flagCode) {
        Page<String> page = new Page<>(pageNo, pageSize);
        String sql = "";
        if(StringUtils.isNotBlank(flagCode)){
            String accesstoken = request.getHeader("Accesstoken");
            String userId = TokenUtil.verifyToken(accesstoken);
            UQueryEntity queryEntity = new UQueryEntity();
            queryEntity.setUserId(userId);
            queryEntity.setFlagCode(flagCode);
            queryEntity = paramAop.startArs(queryEntity,accesstoken,environment);
            String sqlStr = queryEntity.getSql();
            if(sqlStr.contains("()")){
                sqlStr = sqlStr.replace("()","(1=2)");
            }
            sql = sqlStr;
            log.info("visiblePageList sql:{}",sql);
        }
        log.info("visiblePageList username:{},type:{},subjectName:{},environment:{},sql:{}",username,type,subjectName,environment,sql);
        return baseMapper.visibleList(username, type, subjectName,subjectType, page,environment,sql);
    }

    @Override
    public SubjectDetailVO queryInfo(String subjectId) {
        return baseMapper.queryInfo(subjectId);
    }

    @Override
    @Transactional
    public Subject saveMain(SubjectPage subjectPage) {
        Subject subject = new Subject();
        //事件专题的默认分析规则参数-必填
        BeanUtils.copyProperties(subjectPage, subject);
        if (subject.getSubjectType() == null) {
            subject.setSubjectType(1);
        }
        Date timeEnable = subject.getTimeEnable();
        if (timeEnable != null) {
            String format = cn.hutool.core.date.DateUtil.format(timeEnable, "yyyy-MM-dd 00:00:00");
            subject.setTimeEnable(cn.hutool.core.date.DateUtil.parse(format));
        }
        Date timeDisable = subject.getTimeDisable();
        if (timeDisable != null) {
            String format = cn.hutool.core.date.DateUtil.format(timeDisable, "yyyy-MM-dd 23:59:59");
            subject.setTimeDisable(DateUtil.parse(format));
        }
        String subjectCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.SUBJECT_DEFAULT.getValue());
        subject.setSubjectCode(subjectCode);
        String cron = CronUtil.generateCron(subject.getUnit(), subject.getSpace());
        subject.setCron(cron);
        subject.setEstimateStatus("未启用");
        baseMapper.insert(subject);
        //插入专题-类别、项目的绑定关系
        saveMapMain(subject, subjectPage);
        return subject;
    }

    @Override
    @Transactional
    public void updateMain(SubjectPage subjectPage) {
        Subject oldSubject = this.getById(subjectPage.getId());
        Subject subject = new Subject();
        BeanUtils.copyProperties(subjectPage, subject);
        String cron = CronUtil.generateCron(subject.getUnit(), subject.getSpace());
        subject.setCron(cron);
        Date timeEnable = subject.getTimeEnable();
        if (timeEnable != null) {
            String format = DateUtil.format(timeEnable, "yyyy-MM-dd 00:00:00");
            subject.setTimeEnable(DateUtil.parse(format));
        }
        Date timeDisable = subject.getTimeDisable();
        if (timeDisable != null) {
            String format = DateUtil.format(timeDisable, "yyyy-MM-dd 23:59:59");
            subject.setTimeDisable(DateUtil.parse(format));
        }
        baseMapper.updateById(subject);
        //删除专题-类别绑定关系
        subjectTypeMapService.deleteBySubjectId(subject.getId());
        //删除专题-项目的绑定关系
        projectSubjectMapService.deleteBySubjectId(subject.getId());
        //插入新的
        saveMapMain(subject, subjectPage);
        if (oldSubject.getSubjectType() == 1) {
            log.info("更新专题，专题类型为1，更新redis缓存");
            //修改redis缓存，，用于向专题里补充数据
            updateRedisCache(subject, oldSubject);
        }
    }

    @Override
    public void updateStatus(Subject subject) {
        LambdaUpdateWrapper<Subject> updateWrapper = Wrappers.lambdaUpdate();
        String subjectId = subject.getId();
        Integer status = subject.getStatus();
        updateWrapper.set(Subject::getStatus, status).eq(Subject::getId, subjectId);
        if (subject.getStatus() == 1) {
            //判断是否第一次启用
            Subject byId = this.getById(subjectId);
            if (byId.getFirstOpenTime() == null) {
                updateWrapper.set(Subject::getFirstOpenTime, new Date());
                updateWrapper.set(Subject::getEstimateStatus, "预估中");
                //第一次启用时，添加redis缓存，，用于向专题里进数据
                if (byId.getSubjectType() == 3) {
                    //复合专题根据绑定的专题数据时间确定要入库的数据时间范围
                    informationService.supplyByCondition(subjectId, null);
                } else {
                    setRedisCache(subjectId);
                }
            }
        }
        this.update(updateWrapper);
        //和python沟通，这块没用了
        /*CompletableFuture.runAsync(()->{
            if (status == 1) {
                send(subject.getId(), "1");
            } else if (status == 0) {
                //向python发起停止处理请求
                send(subject.getId(), "0");
            }
        });*/
    }

    @Override
    public void deleteMain(String subjectId) {
        baseMapper.deleteById(subjectId);
        CompletableFuture.runAsync(() -> {
            //删除与类别的映射
            subjectTypeMapService.deleteBySubjectId(subjectId);
            //删除与信息源的关联关系
            subjectInfoSourceMapService.delete(subjectId);
            //删除与关键词组的关联关系
            subjectKeywordsMapService.delete(subjectId);
            //删除专题-项目的绑定关系
            projectSubjectMapService.deleteBySubjectId(subjectId);
            //删除事件-模型关系
            subjectModelMapService.remove(Wrappers.<SubjectModelMap>lambdaQuery().eq(SubjectModelMap::getSubjectId, subjectId));
            //删除事件-搜索引擎关系
            subjectSearchEnginesMapService.remove(Wrappers.<SubjectSearchEnginesMap>lambdaQuery().eq(SubjectSearchEnginesMap::getSubjectId, subjectId));
            //删除专题/事件-tpu流程关系
            clbModelArrangeSubjectMapService.remove(Wrappers.<ClbModelArrangeSubjectMap>lambdaQuery().eq(ClbModelArrangeSubjectMap::getSubjectId, subjectId));
            //向python发送消息结束
            //send(subjectId, "-1");
        });
    }

    @Override
    public SubjectPage getSubjectById(String subjectId) {
        SubjectPage subjectPage = baseMapper.selectSubjectById(subjectId);
        int keyWordsNum = keyWordsService.bindCount(subjectPage.getId());
        List<String> subjectIds = new ArrayList<>();
        subjectIds.add(subjectPage.getId());
        int infoSourceNum = infoSourceService.bindSourceCount(subjectIds);
        subjectPage.setInfoSourceNum(infoSourceNum);
        subjectPage.setKeyWordsNum(keyWordsNum);
        return subjectPage;
    }

    @Override
    public void directBindInfoSource(DirectBindInfoVO directBindInfoVO) {
        String subjectId = directBindInfoVO.getSubjectId();
        List<String> bindList = directBindInfoVO.getBindList();
        Integer type = BindTypeEnum.INFO_SOURCE.getvalue();
        for (String infoSourceId : bindList) {
            /*
             * 1.先删除该信息源在专题下的所有数据
             * 2.再判断该信息源在专题已绑定的信息源组下，若不在则新增绑定关系；若在则跳过
             */
            LambdaQueryWrapper<SubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SubjectInfoSourceMap::getSourceId, infoSourceId)
                    .eq(SubjectInfoSourceMap::getSubjectId, subjectId);
            subjectInfoSourceMapService.remove(queryWrapper);
            int num = baseMapper.ynBelowBindGroup(subjectId, infoSourceId);
            if (num == 0) {
                SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
                subjectInfoSourceMap.setSourceId(infoSourceId);
                subjectInfoSourceMap.setSubjectId(subjectId);
                subjectInfoSourceMap.setType(type);
                subjectInfoSourceMapService.save(subjectInfoSourceMap);
            }
        }
        //同步配置到采集
        configurationMessageService.bindInfoSourceSend(subjectId);
    }

    @Override
    public void directRemoveInfoSource(DirectBindInfoVO directBindInfoVO) {
        String subjectId = directBindInfoVO.getSubjectId();
        List<String> excludeList = directBindInfoVO.getExcludeList();
        for (String infoSourceId : excludeList) {
            /*
             * 1.先删除该信息源在专题下的所有数据
             * 2.再判断该信息源在专题已排除的信息源组下，若不在则新增绑定关系；若在则跳过
             */
            LambdaQueryWrapper<SubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SubjectInfoSourceMap::getSourceId, infoSourceId)
                    .eq(SubjectInfoSourceMap::getSubjectId, subjectId);
            subjectInfoSourceMapService.remove(queryWrapper);
            int num = baseMapper.ynBelowExcludeGroup(subjectId, infoSourceId);
            if (num == 0) {
                SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
                subjectInfoSourceMap.setSourceId(infoSourceId);
                subjectInfoSourceMap.setSubjectId(subjectId);
                subjectInfoSourceMap.setType(BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue());
                subjectInfoSourceMapService.save(subjectInfoSourceMap);
            }
        }
        //同步配置到采集
        configurationMessageService.bindInfoSourceSend(subjectId);
    }

    @Override
    public void removeUnBindInfoSource(String subjectId, String infoSourceId) {
        int num = baseMapper.ynBelowExcludeGroup(subjectId, infoSourceId);
        if (num == 0) {
            LambdaUpdateWrapper<SubjectInfoSourceMap> update = Wrappers.lambdaUpdate();
            subjectInfoSourceMapService.update(update.eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                    .eq(SubjectInfoSourceMap::getSourceId, infoSourceId)
                    .eq(SubjectInfoSourceMap::getType, 3)
                    .set(SubjectInfoSourceMap::getType, 1));
        } else {
            LambdaQueryWrapper<SubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SubjectInfoSourceMap::getSourceId, infoSourceId)
                    .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                    .eq(SubjectInfoSourceMap::getType, 3);
            subjectInfoSourceMapService.remove(queryWrapper);
        }
        //同步配置到采集
        configurationMessageService.bindInfoSourceSend(subjectId);
    }

    @Override
    @Transactional
    public void keyWordsBind(SubjectPage subjectPage) {
        List<String> idList = subjectPage.getKeyWordsIds();
        List<SubjectKeywordsMap> mapList = new ArrayList<>();
        if (idList != null && !idList.isEmpty()) {
            for (String keyWordsId : idList) {
                SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
                subjectKeywordsMap.setKeywordsId(keyWordsId);
                subjectKeywordsMap.setSubjectId(subjectPage.getId());
                subjectKeywordsMap.setType(subjectPage.getType());
                subjectKeywordsMap.setBindingType(subjectPage.getBindingType());
                subjectKeywordsMap.setMetaSearchFlag(0);
                mapList.add(subjectKeywordsMap);
            }
            subjectKeywordsMapService.saveBatch(mapList);
        }
        //同步配置到采集
        configurationMessageService.bindKeyWordsSend(subjectPage.getId());
    }

    @Override
    @Transactional
    public void deleteBindKeyWords(SubjectPage subjectPage) {
        List<String> deleteKeyWordsIds = subjectPage.getKeyWordsIds();
        if (CollectionUtils.isNotEmpty(deleteKeyWordsIds)) {
            String subjectId = subjectPage.getId();
            subjectKeywordsMapService.remove(Wrappers.<SubjectKeywordsMap>lambdaQuery()
                    .eq(SubjectKeywordsMap::getSubjectId, subjectId)
                    .in(SubjectKeywordsMap::getKeywordsId, deleteKeyWordsIds)
                    .eq(SubjectKeywordsMap::getBindingType, subjectPage.getBindingType())
            );
            //清除redis里面的绑定关系（包括专题信息，以及搜索引擎）
            /*for (String keyWordsId : deleteKeyWordsIds) {
                KeyWordsPage keyWordsPage = keyWordsService.getKeyWordsById(keyWordsId);
                redisUtil.del(Constants.KEY_WORDS_TO_REDIS_PREFIX + keyWordsPage.getWordsCode());
            }*/
        }
        //同步配置到采集
        configurationMessageService.bindKeyWordsSend(subjectPage.getId());
    }

    @Override
    public void searchEngineBind(SubjectPage subjectPage) {
        //先删除后绑定
        subjectSearchEnginesMapService.remove(Wrappers.<SubjectSearchEnginesMap>lambdaQuery().eq(SubjectSearchEnginesMap::getSubjectId, subjectPage.getId()));
        List<String> idList = subjectPage.getSearchEngineIds();
        List<SubjectSearchEnginesMap> mapList = new ArrayList<>();
        if (CollUtil.isNotEmpty(idList)) {
            for (String searchEngineId : idList) {
                SubjectSearchEnginesMap subjectSearchEnginesMap = new SubjectSearchEnginesMap();
                subjectSearchEnginesMap.setSearchEngineId(searchEngineId);
                subjectSearchEnginesMap.setSubjectId(subjectPage.getId());
                mapList.add(subjectSearchEnginesMap);
            }
            subjectSearchEnginesMapService.saveBatch(mapList);
        }
    }

    @Override
    public List<SearchEnginesVo> bindSearchEngineList(SearchEnginesVo searchEnginesVo) {
        List<SearchEnginesVo> searchEnginesVoList = subjectSearchEnginesMapService.bindSearchEngineList(searchEnginesVo);
        for (SearchEnginesVo searchEnginesVo1 : searchEnginesVoList) {
            if (StringUtils.isNotEmpty(searchEnginesVo1.getSubjectId())) {
                searchEnginesVo1.setYn("1");
            }
        }
        return searchEnginesVoList;
    }

    @Override
    public Result<?> modelBind(SubjectPage subjectPage) {
        List<SubjectModelMap> mapList = new ArrayList<>();
        List<String> hisModelids = new ArrayList<>();
        List<PythonModelVo> models = subjectPage.getModels();
        if (CollUtil.isEmpty(models)) {
            return Result.FAIL(500, "请至少配置一个模型");
        }
        for (PythonModelVo model : models) {
            Integer detailType = model.getDetailType();
            if (ObjectUtil.isEmpty(detailType)) {
                return Result.FAIL(501, "请勾选" + model.getModelName() + "的作用范围");
            }
        }
        if (CollUtil.isNotEmpty(models)) {
            List<PythonModelVo> zengLiang = models.stream().filter(f -> ObjectUtil.isNotEmpty(f.getDetailType()) && (f.getDetailType() == 0 || f.getDetailType() == 2)).collect(Collectors.toList());
            List<PythonModelVo> liShi = models.stream().filter(f -> ObjectUtil.isNotEmpty(f.getDetailType()) && (f.getDetailType() == 1 || f.getDetailType() == 2)).collect(Collectors.toList());
            //检查是否有正在处理的模型任务
            List<ClbSubjectModelDetailTask> list = subjectModelDetailTaskService.list(Wrappers.<ClbSubjectModelDetailTask>lambdaQuery()
                    .eq(ClbSubjectModelDetailTask::getSubjectId, subjectPage.getId()).eq(ClbSubjectModelDetailTask::getTaskStatus, 1)
            );

            if (CollUtil.isNotEmpty(list)) {
                //有正在处理的任务
                for (ClbSubjectModelDetailTask clbSubjectModelDetailTask : list) {
                    String modelIds = clbSubjectModelDetailTask.getModelIds();
                    List<String> list1 = Arrays.asList(modelIds.split(","));
                    for (PythonModelVo model : liShi) {
                        if (list1.contains(model.getId())) {
                            return Result.FAIL(201, JSONUtil.toJsonStr(clbSubjectModelDetailTask));
                        }
                    }
                }
            }
            List<SubjectModelMap> bind = subjectModelMapService.list(Wrappers.<SubjectModelMap>lambdaQuery()
                    .select(SubjectModelMap::getModelId)
                    .eq(SubjectModelMap::getSubjectId, subjectPage.getId())
            );
            //判断提取任务模型中的增量和全量数据，插入关系配置表
            if (CollectionUtil.isNotEmpty(zengLiang)) {
                if (CollectionUtil.isNotEmpty(bind)) {
                    List<PythonModelVo> saves = zengLiang.stream().filter(f -> !bind.stream().map(SubjectModelMap::getModelId).collect(Collectors.toList()).contains(f.getId())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(saves)) {
                        saves.forEach(e -> {
                            SubjectModelMap subjectModelMap = new SubjectModelMap();
                            subjectModelMap.setModelId(e.getId());
                            subjectModelMap.setSubjectId(subjectPage.getId());
                            subjectModelMap.setType(e.getType());
                            subjectModelMap.setSign(1);
                            mapList.add(subjectModelMap);
                        });
                        subjectModelMapService.saveBatch(mapList);
                    }
                } else {
                    zengLiang.forEach(e -> {
                        SubjectModelMap subjectModelMap = new SubjectModelMap();
                        subjectModelMap.setModelId(e.getId());
                        subjectModelMap.setSubjectId(subjectPage.getId());
                        subjectModelMap.setType(e.getType());
                        subjectModelMap.setSign(1);
                        mapList.add(subjectModelMap);
                    });
                    subjectModelMapService.saveBatch(mapList);
                }

            }

            if (CollectionUtil.isNotEmpty(liShi)) {
                liShi.forEach(e -> {
                    if (ObjectUtil.isNotEmpty(e.getDetailType()) && e.getDetailType() != 0) {
                        hisModelids.add(e.getId());
                    }
                });
            }

        }
        //模型中如有历史数据处理任务则发起任务
        if (CollectionUtil.isNotEmpty(hisModelids)) {
            List<AlgorithmModel> modelInfos = modelService.list(Wrappers.<AlgorithmModel>lambdaQuery()
                    .select(AlgorithmModel::getId, AlgorithmModel::getType, AlgorithmModel::getName, AlgorithmModel::getServiceName)
                    .in(AlgorithmModel::getId, hisModelids));
            //处理历史
            ClbSubjectModelDetailTask task = new ClbSubjectModelDetailTask();
            task.setSubjectId(subjectPage.getId());
            task.setTaskStatus(0);
            task.setModelIds(String.join(",", hisModelids));

            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            // 添加半小时
            calendar.add(Calendar.MINUTE, 30);
            Date halfHourLater = calendar.getTime();

            task.setDetailToTime(halfHourLater);
            if (ObjectUtil.isNotEmpty(subjectPage.getTimeEnable())) {
                task.setDetailFromTime(subjectPage.getTimeEnable());
            }
            if (ObjectUtil.isNotEmpty(subjectPage.getTimeDisable())) {
                task.setDetailToTime(subjectPage.getTimeDisable());
            }
            task.setTaskCode(subjectPage.getTaskCode());
            task.setTaskParam(JSONUtil.toJsonStr(modelInfos));
            task.setAllParam(JSONUtil.toJsonStr(subjectPage));
            subjectModelDetailTaskService.save(task);
            kafkaTemplate.send("subjectModelDetail", JSONUtil.toJsonStr(task));
            return Result.OK(task);
        }
        return Result.OK();
    }

    private Map<String, Integer> codeMap = new HashMap<>();

    @Override
    public Result<?> checkIsBreak(SubjectPage subjectPage) {
        List<PythonModelVo> models = subjectPage.getModels();
        if (CollectionUtil.isEmpty(models)) {
            return Result.FAIL(500, "请至少配置一个模型");
        }
        for (PythonModelVo model : models) {
            Integer detailType = model.getDetailType();
            if (ObjectUtil.isEmpty(detailType)) {
                return Result.FAIL(501, "请勾选" + model.getModelName() + "的作用范围");
            }
        }
        List<PythonModelVo> liShi = models.stream().filter(f -> ObjectUtil.isNotEmpty(f.getDetailType()) && (f.getDetailType() == 1 || f.getDetailType() == 2)).collect(Collectors.toList());
        //检查是否有正在处理的模型任务
        List<ClbSubjectModelDetailTask> list = subjectModelDetailTaskService.list(Wrappers.<ClbSubjectModelDetailTask>lambdaQuery()
                .eq(ClbSubjectModelDetailTask::getSubjectId, subjectPage.getId()).eq(ClbSubjectModelDetailTask::getTaskStatus, 1)
        );

        String code = "";
        String s = cn.hutool.core.date.DateUtil.formatDate(new Date());
        if (ObjectUtil.isEmpty(codeMap.get(s))) {
            codeMap = new HashMap<>();
            codeMap.put(s, 1);
            code = s + " 00" + 1;
        } else {
            codeMap.put(s, codeMap.get(s) + 1);
            code = s + " 00" + +codeMap.get(s);
        }
        if (CollectionUtil.isNotEmpty(list)) {
            //有正在处理的任务
            for (ClbSubjectModelDetailTask clbSubjectModelDetailTask : list) {
                String modelIds = clbSubjectModelDetailTask.getModelIds();
                List<String> list1 = Arrays.asList(modelIds.split(","));
                for (PythonModelVo model : liShi) {
                    if (list1.contains(model.getId())) {
                        Result<Object> error = Result.FAIL(201, "此次任务中的模型处理，有部分模型已经存在于其他任务中，并且未执行完毕");
                        error.setResult(clbSubjectModelDetailTask);
                        return error;
                    }
                }
            }
        }
        ClbSubjectModelDetailTask clbSubjectModelDetailTask = new ClbSubjectModelDetailTask();
        clbSubjectModelDetailTask.setTaskCode(code);
        return Result.OK(clbSubjectModelDetailTask);
    }

    @Override
    public void send(String subjectId, String status) {
        Subject subjectById = this.getById(subjectId);
        if (ObjectUtil.isEmpty(subjectById) || subjectById.getCreateTime().after(DateTime.of("2023-11-30", "yyyy-MM-dd"))) {
            return;
        }
        JSONObject jsonObject = commonService.siteInfo(subjectId, null, 1);
        if ("1".equals(status)) {
            jsonObject.put("subjectStatus", "1");
        } else if ("0".equals(status)) {
            jsonObject.put("subjectStatus", "0");
        } else if ("-1".equals(status)) {
            jsonObject.put("subjectStatus", "-1");
        }
        jsonObject.put("subjectStatusDetails", "");
        //调用python接口
        try {
            Map<String, String> headers = new HashMap<>();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            headers.put("Accept", "application/json");
            headers.put("Authorization", "!0gwY$5S@5V&A_+XEu)");
            HttpUtil.doPostWithHeader(subjectProcessorUrl, jsonObject, 3000, headers);
        } catch (IOException e) {
            log.error("传递专题配置信息异常!{}", e.getMessage(), e);
        }
    }

    private void saveMapMain(Subject subject, SubjectPage subjectPage) {
        if (StringUtils.isNotEmpty(subjectPage.getSubjectTypeId())) {
            SubjectTypeMap subjectTypeMap = new SubjectTypeMap();
            subjectTypeMap.setSubjectId(subject.getId());
            subjectTypeMap.setSysOrgCode(subject.getSysOrgCode());
            subjectTypeMap.setTypeId(subjectPage.getSubjectTypeId());
            subjectTypeMapService.save(subjectTypeMap);
        }
        if (StringUtils.isNotEmpty(subjectPage.getProjectId())) {
            ProjectSubjectMap projectSubjectMap = new ProjectSubjectMap();
            projectSubjectMap.setProjectId(subjectPage.getProjectId());
            projectSubjectMap.setSubjectId(subject.getId());
            projectSubjectMapService.save(projectSubjectMap);
        }
    }

    /**
     * 将专题的时间范围存入redis缓存(专题第一次启用时生效)
     *
     * @param subjectId 专题
     * @author lkg
     * @date 2025/2/7
     */
    private void setRedisCache(String subjectId) {
        Subject subject = this.getById(subjectId);
        Date timeEnable = subject.getTimeEnable();
        Date timeDisable = subject.getTimeDisable();
        //date 转 localdate
        LocalDate start;
        LocalDate end;
        if (ObjectUtil.isNull(timeEnable)) {
            start = LocalDate.now().minusMonths(defaultAdvanceMonth);
        } else {
            start = timeEnable.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (ObjectUtil.isNull(timeDisable)) {
            end = LocalDate.now();
        } else {
            end = timeDisable.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        //循环 start 到 end 的每一天
        List<String> dateList = new ArrayList<>();
        for (LocalDate date = end; !date.isBefore(start); date = date.minusDays(1)) {
            // 在这里处理每一天的逻辑
            //格式化date成字符串
            String format = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            dateList.add(format);
        }
        redisUtil.rpushMultipleValues(Constants.HISTORY_SUBJECT_DATE_QUEUE + subject.getSubjectCode(), dateList.toArray(new String[0]));
        if (ObjectUtil.isNotEmpty(subject.getNoPublishTimeFlag()) && 1 == subject.getNoPublishTimeFlag()) {
            //配置了需要拉取无发布时间的才处理
            redisUtil.rpushMultipleValues(Constants.HISTORY_SUBJECT_DATE_QUEUE + subject.getSubjectCode(), "noPublishDate");
        }

    }

    /**
     * 修改专题时间缓存，用于补充数据（只有启用过的专题才会起作用）
     *
     * @param subject    新专题信息
     * @param oldSubject 旧专题信息
     * @author lkg
     * @date 2025/2/7
     */
    private void updateRedisCache(Subject subject, Subject oldSubject) {
        Date firstOpenTime = oldSubject.getFirstOpenTime();
        if (firstOpenTime != null) {
            log.info("修改专题时间缓存，专题id：{}", subject.getId());
            Date oldTimeEnable = oldSubject.getTimeEnable();
            Date oldTimeDisable = oldSubject.getTimeDisable();
            LocalDate oldStart;
            LocalDate oldEnd;
            if (ObjectUtil.isNull(oldTimeEnable)) {
                oldStart = firstOpenTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusMonths(defaultAdvanceMonth);
            } else {
                oldStart = oldTimeEnable.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (ObjectUtil.isNull(oldTimeDisable)) {
                oldEnd = LocalDate.now();
            } else {
                oldEnd = oldTimeDisable.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            Date timeEnable = subject.getTimeEnable();
            Date timeDisable = subject.getTimeDisable();
            if (timeEnable != null || timeDisable != null) {
                List<String> newDateList = new ArrayList<>();
                if (timeEnable != null) {
                    LocalDate start = timeEnable.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (start.isBefore(oldStart)) {
                        for (LocalDate date = start; date.isBefore(oldStart); date = date.plusDays(1)) {
                            // 在这里处理每一天的逻辑
                            //格式化date成字符串
                            String format = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            newDateList.add(format);
                        }
                    }
                }
                if (timeDisable != null) {
                    LocalDate end = timeDisable.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (end.isAfter(oldEnd)) {
                        for (LocalDate date = end; !date.isBefore(oldEnd.plusDays(1)); date = date.minusDays(1)) {
                            // 在这里处理每一天的逻辑
                            //格式化date成字符串
                            String format = date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            newDateList.add(format);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(newDateList)) {

                    if (redisUtil.hasKey(Constants.HISTORY_SUBJECT_DATE_QUEUE + oldSubject.getSubjectCode())) {
                        //防止重复
                        log.info("防止日期重复");
                        newDateList.forEach(e -> {
                           redisUtil.lRemove(Constants.HISTORY_SUBJECT_DATE_QUEUE + oldSubject.getSubjectCode(), 0, e);
                        });
                    }
                    redisUtil.rpushMultipleValues(Constants.HISTORY_SUBJECT_DATE_QUEUE + oldSubject.getSubjectCode(), newDateList.toArray(new String[0]));
                    log.info("修改专题时间缓存，专题id：{}，新增时间完成", oldSubject.getId());
                }
            }
        }
    }

    @Override
    public List<KeyWordsPage> bindKeyWordsListByIdsAndBindType(List<String> ids, String bindingType,Integer metaSearchFlag) {
        return iKeyWordsService.bindKeyWordsListByIdsAndBindType(ids, bindingType,metaSearchFlag);
    }


    @Override
    @Transactional
    public Result<?> infoSourceBindNew(SubjectPage subjectPage) {
        String subjectId = subjectPage.getId();
        List<String> bindIds = subjectPage.getBindIds();
        if (org.springframework.util.StringUtils.isEmpty(subjectId)) {
            return Result.FAIL("专题id不能为空");
        }
        if (StrUtil.isBlank(subjectPage.getSourceBindType())) {
            return Result.FAIL("解绑类型不能为空");
        }
        if (StrUtil.isBlank(subjectPage.getSourceType())) {
            return Result.FAIL("信息源类型不能为空");
        }
        if (CollectionUtil.isEmpty(bindIds) && ("1".equals(subjectPage.getSourceType()) || "2".equals(subjectPage.getSourceType()))) {
            return Result.FAIL("解绑绑定id不能为空");
        }
        if (CollectionUtil.isEmpty(subjectPage.getBindLabels()) && "3".equals(subjectPage.getSourceType())) {
            return Result.FAIL("解绑标签不能为空");
        }
        //绑定信息源组
        if (StrUtil.equals(subjectPage.getSourceType(), "1")) {
            bindInfoSourceGroup(subjectPage);
        }
        //绑定信息源
        if (StrUtil.equals(subjectPage.getSourceType(), "2")) {
            bindInfoSource(subjectPage);
        }
        //绑定标签
        if (StrUtil.equals(subjectPage.getSourceType(), "3")) {
            bindLabels(subjectPage);
        }
        configurationMessageService.bindInfoSourceSend(subjectId);

        return Result.OK("绑定成功");

    }

    @Override
    @Transactional
    public void deleteBindNew(SubjectPage subjectPage) {

        //解绑信息源组
        if (StrUtil.equals(subjectPage.getSourceType(), "1")) {
            unBindInfoSourceGroup(subjectPage);
        }
        //解绑信息源
        if (StrUtil.equals(subjectPage.getSourceType(), "2")) {
            unBindInfoSource(subjectPage);
        }
        //解绑标签
        if (StrUtil.equals(subjectPage.getSourceType(), "3")) {
            unBindLabels(subjectPage);
        }

        configurationMessageService.bindInfoSourceSend(subjectPage.getId());
    }

    @Override
    public String getMinCreateTime(List<String> subjectIdList) {
       return baseMapper.getMinCreateTime(subjectIdList);
    }

    @Override
    public Subject subjectUpdateScope(String subjectId, String type, String scop) {

        Subject byId = super.getById(subjectId);
        if (ObjectUtil.isNotNull(byId)){
            String dataScope = byId.getDataScope();
            if (StrUtil.isNotBlank(dataScope)){
                List<String> scopeList = CollectionUtil.newArrayList(dataScope.split(","));
                if (StrUtil.equals(type,"1") && "1".equals(scop)){
                    scopeList.add("1");
                }else if (StrUtil.equals(type,"1") && "0".equals(scop)){
                    scopeList.remove("1");
                }
                if (StrUtil.equals(type,"2") && "1".equals(scop)){
                    scopeList.add("2");
                }else if (StrUtil.equals(type,"2") && "0".equals(scop)){
                    scopeList.remove("2");
                }
                if (StrUtil.equals(type,"3") && "1".equals(scop)){
                    scopeList.add("3");
                }else if (StrUtil.equals(type,"3") && "0".equals(scop)){
                    scopeList.remove("3");
                }
                if (CollectionUtil.isNotEmpty(scopeList)) {
                    scopeList = scopeList.stream().distinct().collect(Collectors.toList());
                    String join = StrUtil.join(",", scopeList);
                    byId.setDataScope(join);
                }else {
                    byId.setDataScope(null);
                }
                this.updateById(byId);
            }else {
                if ("1".equals(scop)) {
                    byId.setDataScope(scop);
                }
                this.updateById(byId);
            }
        }
        return byId;
    }

    private void unBindInfoSourceGroup(SubjectPage subjectPage) {

        String sourceBindType = subjectPage.getSourceBindType();
        List<String> idList = subjectPage.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (StrUtil.equals(sourceBindType, "1")) {
            //解绑通用信息源组
            unbindInfoSource(subjectPage, idList, BindTypeEnum.INFO_SOURCE_GROUP.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "2")) {
            //解绑定向信息源组
            unbindInfoSource(subjectPage, idList, BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "3")) {
            //解绑屏蔽信息源组
            unbindInfoSource(subjectPage, idList, BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
        }

    }

    private void unBindLabels(SubjectPage subjectPage) {
        String sourceBindType = subjectPage.getSourceBindType();
        List<BindLabelVo> bindLabels = subjectPage.getBindLabels();
        if (CollectionUtil.isEmpty(bindLabels)) {
            return;
        }
        if (StrUtil.equals(sourceBindType, "1")) {
            //解绑通用标签
            unBindLabel(subjectPage, BindTypeEnum.INFO_SOURCE_LABEL.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "2")) {
            //解绑定向标签
            unBindLabel(subjectPage, BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "3")) {
            //解绑屏蔽标签
            unBindLabel(subjectPage, BindTypeEnum.EXCLUDE_INFO_SOURCE_LABEL.getvalue());
        }
    }

    private void unBindLabel(SubjectPage subjectPage, Integer type) {
        List<BindLabelVo> bindLabels = subjectPage.getBindLabels();
        if (CollectionUtil.isEmpty(bindLabels)) {
            return;
        }
        Set<String> labelCode = new HashSet<>();
        Set<String> labelItemCode = new HashSet<>();
        List<SubjectInfoSourceMap> mapList = new ArrayList<>();
        for (BindLabelVo bindLabelVo : bindLabels) {
            labelCode.add(bindLabelVo.getLabelCode());
            labelItemCode.add(bindLabelVo.getLabelItemCode());

        }
        iSubjectInfoSourceMapService.remove(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .in(SubjectInfoSourceMap::getSourceId, labelCode)
                .in(SubjectInfoSourceMap::getSourceItemId, labelItemCode)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectPage.getId())
                .eq(SubjectInfoSourceMap::getType, type));
    }

    private void unBindInfoSource(SubjectPage subjectPage) {
        String sourceBindType = subjectPage.getSourceBindType();
        List<String> idList = subjectPage.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (StrUtil.equals(sourceBindType, "1")) {
            //解绑通用信息源
            unbindInfoSource(subjectPage, idList, BindTypeEnum.INFO_SOURCE.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "2")) {
            //解绑定向信息源
            unbindInfoSource(subjectPage, idList, BindTypeEnum.DIRECTIONA_INFO_SOURCE.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "3")) {
            //解绑屏蔽信息源
            unbindInfoSource(subjectPage, idList, BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue());
        }
    }

    private void unbindInfoSource(SubjectPage subjectPage, List<String> idList, Integer bindType) {
        iSubjectInfoSourceMapService.deleteInfoSourceIds(subjectPage.getId(), idList, bindType);

        if (BindTypeEnum.INFO_SOURCE_GROUP.getvalue().equals(bindType)) {
            //更改打分模型中的信息源组绑定情况
            List<ScoreModelVo> scoreModelList = scoreModelService.queryScoreModel(subjectPage.getId(), null);
            for (String groupId : idList) {
                for (ScoreModelVo scoreModel : scoreModelList) {
                    JSONArray jsonArray = JSONArray.parseArray(scoreModel.getData().toString());
                    JSONObject jsonObject = jsonArray.getJSONObject(0);
                    JSONArray children = jsonObject.getJSONArray("children");
                    //若信息源打分配置中已经存在的有相同的，则去除掉这部分
                    for (int i = 0; i < children.size(); i++) {
                        String infoSourceGroupId = children.getJSONObject(i).getString("infoSourceGroupId");
                        if (groupId.equals(infoSourceGroupId)) {
                            children.remove(i);
                            break;
                        }
                    }
                    jsonObject.put("children", children);
                    jsonArray.remove(0);
                    jsonArray.add(0, jsonObject);
                    scoreModel.setData(jsonArray.toJSONString());
                    scoreModel.setChangeType(0);
                    //去除完之后，更新进去
                    scoreModelService.addOrUpdate(scoreModel, subjectPage.getCategory());
                }
            }
        }
    }


    private void bindInfoSourceGroup(SubjectPage subjectPage) {
        String sourceBindType = subjectPage.getSourceBindType();
        List<String> idList = subjectPage.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (StrUtil.equals(sourceBindType, "1")) {
            //绑定通用信息源组
            bindInfoSource(subjectPage, idList, BindTypeEnum.INFO_SOURCE_GROUP.getvalue());

        }
        if (StrUtil.equals(sourceBindType, "2")) {
            //绑定定向信息源组
            bindInfoSource(subjectPage, idList, BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "3")) {
            //绑定屏蔽信息源组
            bindInfoSource(subjectPage, idList, BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue());
        }
    }

    private void bindInfoSource(SubjectPage subjectPage, List<String> idList, Integer type) {
        List<SubjectInfoSourceMap> mapList = new ArrayList<>();
        for (String infoSourceId : idList) {
            SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
            subjectInfoSourceMap.setSourceId(infoSourceId);
            subjectInfoSourceMap.setSubjectId(subjectPage.getId());
            subjectInfoSourceMap.setType(type);
            mapList.add(subjectInfoSourceMap);
        }
        if (BindTypeEnum.INFO_SOURCE_GROUP.getvalue().equals(type)) {
            //判断打分模型是否存在过，若存在则更改
            List<ScoreModelVo> scoreModelList = scoreModelService.queryScoreModel(subjectPage.getId(), null);
            for (ScoreModelVo scoreModelVo : scoreModelList) {
                String typeId = scoreModelVo.getType();
                JSONArray jsonArray = JSONArray.parseArray(scoreModelVo.getData().toString());
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                JSONArray children = jsonObject.getJSONArray("children");
                int count = children.size();
                //判断是否存在节点（没有则直接添加）
                if (count == 0) {
                    for (int i = 0; i < idList.size(); i++) {
                        InfoSourceGroup group = infoSourceGroupService.getGroupById(idList.get(i));
                        if (group != null) {
                            String newId = typeId + "-1-" + (i + 1);
                            JSONObject childJsonObject = new JSONObject();
                            childJsonObject.put("name", group.getGroupName());
                            childJsonObject.put("id", newId);
                            childJsonObject.put("infoSourceGroupId", idList.get(i));
                            childJsonObject.put("fraction", 80);
                            children.add(childJsonObject);
                        }
                    }
                } else {
                    String id = children.getJSONObject(count - 1).getString("id");
                    for (int i = 0; i < idList.size(); i++) {
                        InfoSourceGroup group = infoSourceGroupService.getGroupById(idList.get(i));
                        if (group != null) {
                            String newId = typeId + "-1-" + (Integer.parseInt(id.substring(id.lastIndexOf("-") + 1)) + i + 1);
                            JSONObject childJsonObject = new JSONObject();
                            childJsonObject.put("name", group.getGroupName());
                            childJsonObject.put("id", newId);
                            childJsonObject.put("infoSourceGroupId", idList.get(i));
                            childJsonObject.put("fraction", 80);
                            children.add(childJsonObject);
                        }
                    }
                }
                jsonObject.put("children", children);
                jsonArray.remove(0);
                jsonArray.add(0, jsonObject);
                scoreModelVo.setData(jsonArray.toJSONString());
                scoreModelVo.setChangeType(0);
                //增加完之后，更新进去
                scoreModelService.addOrUpdate(scoreModelVo, subjectPage.getCategory());
            }
        }
        iSubjectInfoSourceMapService.saveBatch(mapList);
    }

    private void bindInfoSource(SubjectPage subjectPage) {
        String sourceBindType = subjectPage.getSourceBindType();
        List<String> idList = subjectPage.getBindIds();
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        if (StrUtil.equals(sourceBindType, "1")) {
            //绑定通用信息源
            bindInfoSource(subjectPage, idList, BindTypeEnum.INFO_SOURCE.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "2")) {
            //绑定定向信息源
            bindInfoSource(subjectPage, idList, BindTypeEnum.DIRECTIONA_INFO_SOURCE.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "3")) {
            //绑定屏蔽信息源
            bindInfoSource(subjectPage, idList, BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue());
        }
    }

    private void bindLabels(SubjectPage subjectPage) {

        String subjectId = subjectPage.getId();
        String sourceBindType = subjectPage.getSourceBindType();
        List<BindLabelVo> bindLabels = subjectPage.getBindLabels();
        if (CollectionUtil.isEmpty(bindLabels)) {
            return;
        }
        if (StrUtil.equals(sourceBindType, "1")) {
            //绑定通用标签信息源
            bindLabels(subjectId, bindLabels, BindTypeEnum.INFO_SOURCE_LABEL.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "2")) {
            //绑定定向标签信息源
            bindLabels(subjectId, bindLabels, BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue());
        }
        if (StrUtil.equals(sourceBindType, "3")) {
            //绑定屏蔽标签信息源
            bindLabels(subjectId, bindLabels, BindTypeEnum.EXCLUDE_INFO_SOURCE_LABEL.getvalue());
        }

    }

    private void bindLabels(String subjectId, List<BindLabelVo> bindLabels, Integer bindType) {
        List<SubjectInfoSourceMap> mapList = new ArrayList<>();

        for (BindLabelVo infoSourceId : bindLabels) {
            SubjectInfoSourceMap subjectInfoSourceMap = new SubjectInfoSourceMap();
            subjectInfoSourceMap.setSourceId(infoSourceId.getLabelCode());
            subjectInfoSourceMap.setSourceItemId(infoSourceId.getLabelItemCode());
            subjectInfoSourceMap.setSubjectId(subjectId);
            subjectInfoSourceMap.setType(bindType);
            mapList.add(subjectInfoSourceMap);
        }
        iSubjectInfoSourceMapService.saveBatch(mapList);
    }


}

