package com.zzsn.event.controller.thirdApi;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.vo.KeywordsVO;
import com.zzsn.event.vo.RegionVO;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 *
 *
 * @author lkg
 * @date 2024/7/19
 */
@Getter
@Setter
public class ThirdAddEventVO {

    private String id;
    /**图标*/
    private String eventIcon;
    /**名称*/
    private String eventName;
    /**事件类型*/
    private String eventType;
    /**事件描述*/
    private String eventDescribe;
    /**开始时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    /**结束时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    /**标签*/
    private String eventLabel;
    /**是否公开*/
    private Integer facePublic;
    /**事件创建方式(1-用户直接创建;2-基于挖掘的事件创建)*/
    private Integer category;

    /**事件地域信息*/
    List<RegionVO> regionList;
    /**关键词*/
    private KeywordsVO keywordsVO;

    /**伪事件id*/
    private String fakeEventId;

    /**用户账号*/
    private String username;
}
