package com.zzsn.event.vo.log;

import com.zzsn.event.enums.EnumSourceType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

/**
 * 持有类为数据生命周期日志{@link DataLifecycleLog}
 * 此类记录资讯的信息源信息
 *
 * @author 张宗涵
 * @date 2024/4/25
 */
@Getter
@Setter
@FieldNameConstants
public class Source {
    /**
     * 信息源id
     */
    private String sourceId;

    /**
     * 信息源类型
     */
    private EnumSourceType sourceType;

    /**
     * 信息源名称
     */
    private String sourceName;

    /**
     * 信息源优先级
     */
    private String sourceLevel;
}
