package com.zzsn.event.util;

import java.util.*;
import java.util.Map.Entry;

/**
 * 基于词典文章热词推荐
 * @author kongliufeng
 *
 */
public class HotWordUtil {

	 public static void main(String[] args) {
		 List<Entry<String, String>> entries = new ArrayList<>();
		 entries.add(new AbstractMap.SimpleEntry<>("1", "关键词1"));
		 entries.add(new AbstractMap.SimpleEntry<>("1", "关键词2"));
		 entries.add(new AbstractMap.SimpleEntry<>("2", "关键词1"));
		 entries.add(new AbstractMap.SimpleEntry<>("2", "关键词2"));
		 entries.add(new AbstractMap.SimpleEntry<>("1", "关键词3"));

		 Map<String, Integer> coOccurrenceMap = calculateCoOccurrence_map(entries);

		 for (Entry<String, Integer> coOccurrence : coOccurrenceMap.entrySet()) {
			 System.out.println(coOccurrence.getKey() + ": " + coOccurrence.getValue());
		 }

	 }


	/**
	 * 计算关键词共现次数
	 * @author liuxiaopeng
	 * @data 2024-05-31 下午5:18:21
	 */
	public static Map<String, Integer> calculateCoOccurrence_map(List<Entry<String, String>> entries) {
		Map<String, Integer> coOccurrenceMap = new HashMap<>();

		// 先将文章ID分组，便于后续处理
		Map<String, List<String>> articleKeywords = new HashMap<>();
		for (Entry<String, String> entry : entries) {
			articleKeywords.putIfAbsent(entry.getKey(), new ArrayList<>());
			articleKeywords.get(entry.getKey()).add(entry.getValue());
		}

		// 计算共现次数
		for (List<String> keywords : articleKeywords.values()) {
			for (int i = 0; i < keywords.size(); i++) {
				for (int j = i + 1; j < keywords.size(); j++) {
					String pair = sortKeywords(keywords.get(i), keywords.get(j));
					coOccurrenceMap.put(pair, coOccurrenceMap.getOrDefault(pair, 0) + 1);
				}
			}
		}

		return coOccurrenceMap;
	}

	/**
	 * 计算关键词共现次数
	 * @author liuxiaopeng
	 * @data 2024-05-31 下午5:18:21
	 */
	public static Map<String, Integer> calculateCoOccurrence_list(List<List<String>> wordList) {
		Map<String, Integer> coOccurrenceMap = new HashMap<>();
		// 计算共现次数
		for (List<String> keywords : wordList) {
			for (int i = 0; i < keywords.size(); i++) {
				for (int j = i + 1; j < keywords.size(); j++) {
					String pair = sortKeywords(keywords.get(i), keywords.get(j));
					coOccurrenceMap.put(pair, coOccurrenceMap.getOrDefault(pair, 0) + 1);
				}
			}
		}
		return coOccurrenceMap;
	}

	// 辅助方法，确保关键词对以固定的顺序排列，避免("关键词1", "关键词2")和("关键词2", "关键词1")被视为两个不同的键
	private static String sortKeywords(String keyword1, String keyword2) {
		return keyword1.compareTo(keyword2) < 0 ? (keyword1 + "&" + keyword2) : (keyword2 + "&" + keyword1);
	}

}
