package com.zzsn.event.config;

import com.zzsn.event.config.interceptor.LoginInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author lkg
 * @description: 拦截配置
 * @date 2021/7/1 9:43
 */
@Configuration
public class WebConfigure implements WebMvcConfigurer {

    @Value("${jeecg.shiro,excludeUrls:}")
    private String ALLOW_URL;
    //服务部署环境 clb：克虏宝  yjzx：研究中心
    @Value("${server.profiles:clb}")
    private String profiles;
    @Bean
    public LoginInterceptor loginInterceptor() {
        return new LoginInterceptor(profiles);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        //用户登录拦截
        registry.addInterceptor(loginInterceptor()).addPathPatterns("/**").excludePathPatterns(ALLOW_URL.split(","));

    }


}
