package com.zzsn.event.service;


import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.vo.PropagationPathVo;

import java.util.List;

/**
 * @author lkg
 * @description: 专题分析
 * @date 2022/7/20 11:25
 */
public interface AnalysisService {

    /**
     * 事件脉络
     * @param subjectId 专题id
     * @param fakeNum 专题事件脉络展示 伪事件脉络 的资讯数量阈值
     * @return java.util.List<com.zzsn.subjectAnalysis.entity.SubjectAnalysis>
     */
    List<SubjectAnalysis> eventContext(String subjectId, int fakeNum);

    /**
     * 传播路径
     * @param subjectId 专题id
     * @return com.zzsn.subjectAnalysis.vo.PropagationPathVo
     */
    PropagationPathVo propagationPath(String subjectId);
}
