package com.zzsn.event.config.interceptor;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.constant.Result;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * 拦截token，获取用户信息
 *
 * @author lkg
 * @date 2024/4/29
 */
public class UserInfoInterceptor implements HandlerInterceptor {


    @Value("${checkToken.url:}")
    private String checkTokenUrl;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader(Constants.HEADER_KEY);
        Result<?> result = getUserInfo(token);
        Integer code = result.getCode();
        if (code == 500) {
            returnJson(response, JSON.toJSONString(Result.FAIL(500, "第三方用户验证未通过,请检查令牌是否正确")));
            return false;
        }
        UserVo userVo = JSONObject.parseObject(JSON.toJSONString(result.getResult()), UserVo.class);
        UserUtil.setLoginUser(userVo);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserUtil.removeUser();
    }


    private Result<?> getUserInfo(String token){
        Result<?> bean;
        try {
            String body = HttpRequest.post(checkTokenUrl)
                    .header(Constants.HEADER_KEY,token)
                    .execute().body();
            bean = JSONObject.parseObject(body, Result.class);
        } catch (Exception e) {
            bean = Result.FAIL();
        }
        return bean;
    }

    private void returnJson(HttpServletResponse response, String json) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=utf-8");
        try (PrintWriter writer = response.getWriter()) {
            writer.println(json);
        } catch (Exception ignored) {
        }
    }
}
