package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 国内地域表
 * @Author: jeecg-boot
 * @Date:   2022-03-09
 * @Version: V1.0
 */
@Data
@TableName("sys_base_domestic_region")
@ApiModel(value="sys_base_domestic_region对象", description="国内地域表")
public class SysBaseDomesticRegion implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**名称*/
	@Excel(name = "名称", width = 15)
    @ApiModelProperty(value = "名称")
    private String name;
	/**别名*/
	@Excel(name = "别名", width = 15)
    @ApiModelProperty(value = "别名")
    private String alias;
	/**行政编码*/
	@Excel(name = "行政编码", width = 15)
    @ApiModelProperty(value = "行政编码")
    private String code;
	/**所属省或直辖市*/
	@Excel(name = "所属省或直辖市", width = 15)
    @ApiModelProperty(value = "所属省或直辖市")
    private String topId;
	/**地理区*/
	@Excel(name = "地理区", width = 15)
    @ApiModelProperty(value = "地理区")
    private String area;
	/**经济区*/
	@Excel(name = "经济区", width = 15)
    @ApiModelProperty(value = "经济区")
    private String economy;
	/**所有pid*/
	@Excel(name = "所有pid", width = 15)
    @ApiModelProperty(value = "所有pid")
    private String pathIds;
	/**组合词*/
	@Excel(name = "组合词", width = 15)
    @ApiModelProperty(value = "组合词")
    private String composeWords;
	/**层级*/
	@Excel(name = "层级", width = 15)
    @ApiModelProperty(value = "层级")
    private Integer level;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
	/**父级节点*/
	@Excel(name = "父级节点", width = 15)
    @ApiModelProperty(value = "父级节点")
    private String pid;
	/**是否有子节点*/
	@Excel(name = "是否有子节点", width = 15, dicCode = "yn")
    @ApiModelProperty(value = "是否有子节点")
    private String hasChild;
    /**经度*/
    private String longitude;
    /**纬度*/
    private String latitude;
}
