package com.zzsn.event.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 专题数据同步配置类
 */
@Data
@Component
@RefreshScope
@ConfigurationProperties(SubjectSyncConfig.PREFIX)
public class SubjectSyncConfig {
    public static final String PREFIX = "subject.sync";
    private List<Config> configs= new ArrayList<>();

    @Data
    public static class Config {
        //环境名称
        private String name;
        //环境编码
        private String code;
        //访问地址
        private String domain;
        //鉴权地址
        private String loginUrl;
        //专题列表查询地址
        private String subjectListUrl;
        //查询接口地址
        private String findDataUrl;
        //用户名
        private String username;
        //密码
        private String password;
    }
    @Data
    public static class ConfigVo {
        //环境名称
        private String name;
        //环境编码
        private String code;
    }
}
