package com.zzsn.event.service;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.KeywordsVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 关键词管理
 * @Author: jeecg-boot
 * @Date: 2021-11-26
 * @Version: V1.0
 */
public interface IKeyWordsService extends IService<KeyWords> {


    IPage<KeyWordsPage> pageByTypeId(KeyWords keyWords, Integer pageNo, Integer pageSize, String keyWordsTypeId, Boolean search, String subjectId,String bindingType);
    /**
     * 插入关键词及类别对应关系
     */
    JSONObject saveMain(KeyWordsPage keyWordsPage);
    /**
     * 更新关键词及类别对应关系
     */
    void updateMain(KeyWordsPage keyWordsPage);

    /**
     * 删除所有关键词及映射关系
     */
    void deleteMain(String keyWordsId);

    /**
     * 根据id获取详情
     *
     * @param keyWordsId 关键词id
     * @author lkg
     * @date 2024/12/19
     */
    KeyWordsPage getKeyWordsById(String keyWordsId);

    /**
     * 新增事件时,默认新增关键词信息
     *
     * @param event 事件信息
     * @param keyword 关键词
     * @param exclusionWord 排除词
     * @author lkg
     * @date 2024/12/19
     */
    KeyWords saveKeyword(Event event, String keyword, String exclusionWord);

    KeyWords saveKeyword(String subjectId, KeyWords keyWords);
    /**
     * 事件绑定关键词信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2024/9/12
     */
    KeywordsVO keywordInfoByEventId(String eventId);

    /**
     * 专题绑定的关键词组-分页列表
     *
     * @param subjectIds 专题id集合
     * @param groupName  词组名称
     * @param wordName   关键词名称
     * @author lkg
     * @date 2024/5/7
     */
    List<KeyWordsPage> bindKeyWordsList(List<String> subjectIds, String groupName, String wordName);

    /**
     * 专题绑定关键词组的数量
     *
     * @param subjectId 阻焊提/事件id
     * @author lkg
     * @date 2024/12/19
     */
    Integer bindCount(String subjectId);

    List<KeyWordsPage> listByTypeIdList(String userId,String customerId,List<String> typeIds, String subjectId, int status,String bindingType);

    Integer countByTypeAndIdList(String userId, String customerId,List<String> finalIdList, String subjectId);

    List<KeyWordsPage> bindKeyWordsListByIdsAndBindType(List<String> ids, String bindingType,Integer metaSearchFlag);
}
