package com.zzsn.event.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.EventContext;
import com.zzsn.event.service.EventContextService;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.vo.EventContextModifyVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 事件相关分析维护
 *
 * @author lkg
 * @date 2024/5/11
 */
@RestController
@RequestMapping("/maintenance")
public class EventMaintenanceController {

    @Autowired
    private IEventService eventService;
    @Autowired
    private EventContextService eventContextService;



    /**
     * 编辑核心摘要
     *
     * @param event 事件信息
     * @author lkg
     * @date 2025/7/15
     */
    @PostMapping("/event/description/update")
    public Result<?> eventContextList(@RequestBody Event event) {
        LambdaUpdateWrapper<Event> update = Wrappers.lambdaUpdate();
        update.set(Event::getEventDescribe, event.getEventDescribe())
                .set(Event::getYnManualEdit,1)
                .eq(Event::getId, event.getId());
        eventService.update(update);
        return Result.OK();
    }


    /**
     * 事件脉络新增/编辑
     *
     * @param eventContextModifyVO 事件脉络信息
     * @author lkg
     * @date 2025/7/15
     */
    @PostMapping("/eventContext/modify")
    public Result<?> eventContextModify(@RequestBody EventContextModifyVO eventContextModifyVO){
        eventContextService.eventContextModify(eventContextModifyVO);
        return Result.OK();
    }

    /**
     * 删除事件脉络
     *
     * @param keyNodeId 脉络关健节点id
     * @author lkg
     * @date 2025/7/15
     */
    @GetMapping("/eventContext/remove")
    public Result<?> eventContextRemove(@RequestParam String keyNodeId){
        LambdaQueryWrapper<EventContext> queryWrapper = Wrappers.lambdaQuery();
        eventContextService.remove(queryWrapper.eq(EventContext::getId, keyNodeId).or().eq(EventContext::getParentId, keyNodeId));
        return Result.OK();
    }
}
