package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.InfoSourceGroup;
import com.zzsn.event.mapper.InfoSourceGroupMapper;
import com.zzsn.event.service.InfoSourceGroupService;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.vo.GroupTreeVO;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.SubjectTreeVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
@Service
public class InfoSourceGroupServiceImpl extends ServiceImpl<InfoSourceGroupMapper, InfoSourceGroup> implements InfoSourceGroupService {

    @Override
    public InfoSourceGroup getGroupById(String groupId) {
        return baseMapper.selectGroupById(groupId);
    }

    @Override
    public List<String> selectInfoSourceByGroupIds(List<String> groupIds) {
        return baseMapper.selectInfoSourceByGroupIds(groupIds);
    }

    @Override
    public List<InfoSourceGroupPage> bindInfoSourceList(String subjectId) {
        return baseMapper.selectInfoSourceListById(subjectId,null);
    }

    @Override
    public List<GroupTreeVO> GroupAndTypeTree() {
        List<GroupTreeVO> tree = new ArrayList<>();
        List<GroupTreeVO> groupTreeVOS = baseMapper.groupAndTypeTree();
        if (CollectionUtils.isNotEmpty(groupTreeVOS)) {
            tree = TreeUtil.tree(groupTreeVOS, "0");
            tree.sort(Comparator.comparing(GroupTreeVO::getCreateTime));
        }
        return tree;
    }

    @Override
    public List<GroupTreeVO> infourceMainGroupAndTypeTree() {
        List<GroupTreeVO> tree = new ArrayList<>();
        List<GroupTreeVO> groupTreeVOS = baseMapper.infourceMainGroupAndTypeTree();
        if (CollectionUtils.isNotEmpty(groupTreeVOS)) {
            tree = TreeUtil.tree(groupTreeVOS, "0");
            tree.sort(Comparator.comparing(GroupTreeVO::getCreateTime));
        }
        return tree;
    }
}
