package com.zzsn.event.mapper;

import com.zzsn.event.entity.EventExtract;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.vo.EventExtractVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author lenovo
 * @description 针对表【event_extract(事件)】的数据库操作Mapper
 * @createDate 2024-09-07 18:00:28
 * @Entity com.zzsn.event.entity.EventExtract
 */
@Mapper
public interface EventExtractMapper extends BaseMapper<EventExtract> {

    /**
     * 伪事件信息列表
     *
     * @param eventName 事件名称
     * @param eventType 时间分类
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param offset    偏移量
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/9/9
     */
    List<EventExtractVO> pageList(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                                  @Param("startTime") String startTime, @Param("endTime") String endTime,
                                  @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 伪事件信息总数量
     *
     * @param eventName 事件名称
     * @param eventType 时间分类
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/9/9
     */
    Long totalCount(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                    @Param("startTime") String startTime, @Param("endTime") String endTime);
}




