package com.zzsn.event.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.constant.Result;
import com.zzsn.event.service.EventExtractService;
import com.zzsn.event.vo.EventExtractVO;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 *
 * @author lkg
 * @date 2024/9/7
 */
@Api(tags = "事件审核管理")
@RestController
@RequestMapping("/examine")
public class EventExtractController {

    @Autowired
    private EventExtractService eventExtractService;

    /**
     * 伪事件信息分页列表
     *
     * @param eventName 事件名称
     * @param eventType 时间分类
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param pageNo    当前页
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/9/9
     */
    public Result<?> pageList(@RequestParam(name = "eventName", required = false) String eventName,
                              @RequestParam(name = "eventType", required = false) Integer eventType,
                              @RequestParam(name = "startTime", required = false) String startTime,
                              @RequestParam(name = "endTime", required = false) String endTime,
                              @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize){
        IPage<EventExtractVO> page = eventExtractService.pageList(eventName, eventType, startTime, endTime, pageNo, pageSize);
        return Result.OK(page);
    }

    /**
     * 删除
     *
     * @param id 主键id
     * @author lkg
     * @date 2024/9/9
     */
    @GetMapping("/delete")
    public Result<?> delete(@RequestParam String id){
        eventExtractService.removeById(id);
        return Result.OK();
    }
}
