package com.zzsn.event.util;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;

public class DateUtil {

    private static SimpleDateFormat format;

    /**
     * Date转String
     *
     * @param date      时间日期
     * @param formatStr 格式
     * @return java.lang.String
     */
    public static String dateToString(Date date, String formatStr) {
        format = new SimpleDateFormat(formatStr);
        return format.format(date);
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    /**
     * String转Date
     *
     * @param dateStr   时间字符串
     * @param formatStr 格式
     * @return java.lang.String
     */
    public static Date stringToDate(String dateStr, String formatStr) {
        format = new SimpleDateFormat(formatStr);
        Date parse = null;
        try {
            parse = format.parse(dateStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return parse;
    }

    /**
     * 增加天数
     *
     * @param d   目标时间
     * @param day 天数
     * @return java.util.Date
     */
    public static Date addDate(Date d, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(Calendar.DATE, day);
        return cal.getTime();
    }


    /**
     * 格式化时间字符串
     *
     * @param dateStr 时间字符串
     * @param format1  字符串转时间格式
     * @param format2  时间转字符串格式
     * @return java.lang.String
     * @author lkg
     */
    public static String formatStr(String dateStr, String format1, String format2) {
        return dateToString(stringToDate(dateStr, format1), format2);
    }

    /**
     * 两个时间相差的天数
     *
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return java.lang.Integer
     * @author lkg
     */
    public static Integer betweenTwoDate(String startDate, String endDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate start = LocalDate.parse(startDate, formatter);
        LocalDate end = LocalDate.parse(endDate, formatter);
        long between = ChronoUnit.DAYS.between(start, end);
        return (int) between;
    }

    /**
     * 两个时间相差的天数
     *
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return java.lang.Integer
     * @author lkg
     */
    public static Integer betweenTwoDate(Date startDate, Date endDate) {
        String pattern = "yyyy-MM-dd";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate start = LocalDate.parse(dateToString(startDate, pattern), formatter);
        LocalDate end = LocalDate.parse(dateToString(endDate, pattern), formatter);
        long between = ChronoUnit.DAYS.between(start, end);
        return Math.abs((int) between);
    }

    public static String getDayBeforeOrAfter(String dateStr, int num){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(stringToDate(dateStr,"yyyy-MM-dd"));
        calendar.add(Calendar.DATE,num);
        return dateToString(calendar.getTime(),"yyyy-MM-dd 00:00:00");
    }

    public static List<String> betweenDate(String startDate,String endDate) {
        List<String> dateList = new ArrayList<>();
        String formatStr = "yyyy-MM-dd";
        try {
            Date dayOne = stringToDate(startDate, formatStr);
            Date dayTwo = stringToDate(endDate, formatStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dayOne);
            dateList.add(startDate);
            while (dayTwo.after(calendar.getTime())) {
                calendar.add(Calendar.DAY_OF_MONTH,1);
                dateList.add(format(calendar.getTime(),formatStr));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dateList;
    }

    public static List<String> getMonthsBetween(String startDateStr, String endDateStr) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");

        LocalDate startDate = LocalDate.parse(startDateStr, dateFormatter);
        LocalDate endDate = LocalDate.parse(endDateStr, dateFormatter);

        List<String> months = new ArrayList<>();

        YearMonth startYearMonth = YearMonth.from(startDate);
        YearMonth endYearMonth = YearMonth.from(endDate);

        for (YearMonth yearMonth = startYearMonth;
             !yearMonth.isAfter(endYearMonth);
             yearMonth = yearMonth.plusMonths(1)) {
            months.add(yearMonth.format(monthFormatter));
        }

        return months;
    }

    public static String format(Date d, String format){
        if (d == null) {
            return "";
        }
        SimpleDateFormat myFormatter = new SimpleDateFormat(format);
        myFormatter.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        return myFormatter.format(d);
    }
}
