package com.zzsn.event.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.entity.KeywordsTypeMap;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.entity.SubjectKeywordsGroupRelation;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.service.*;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.vo.SearchWordVO;
import com.zzsn.event.vo.SubjectKeywordsMap;
import com.zzsn.event.vo.SubjectPage;
import com.zzsn.event.vo.SubjectSimpleVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 简化专题创建流程
 *
 * @author lkg
 * @date 2025/1/9
 */
@Service
public class SubjectSimpleServiceImpl implements SubjectSimpleService {

    @Autowired
    private SubjectService subjectService;
    @Autowired
    private IKeyWordsService keywordWordsService;
    @Autowired
    private IKeywordsTypeMapService keywordsTypeMapService;
    @Autowired
    private SubjectKeywordsGroupRelationService subjectKeywordsGroupRelationService;
    @Autowired
    private ISubjectKeywordsMapService subjectKeywordsMapService;

    @Autowired
    private CodeGenerateUtil codeGenerateUtil;

    private final static String KEYWORDS_TYPE_ID = "1476498704680194050";
    private final static String PROJECT_ID = "1476527644425682945";

    @Override
    public Subject createSubject(SubjectSimpleVO subjectSimpleVO) {
        SubjectPage subjectPage = new SubjectPage();
        BeanUtils.copyProperties(subjectSimpleVO, subjectPage);
        subjectPage.setProjectId(PROJECT_ID);
        Subject subject = subjectService.saveMain(subjectPage);
        //关键词绑定  todo 关键词创建时是否还需要 创建定时任务、redis缓存以及发送kafka消息
        List<SearchWordVO> keywords = subjectSimpleVO.getKeywords();
        modifyKeyword(subject.getId(), subject.getSubjectName(), keywords);
        return subject;
    }

    @Override
    public void editSubject(SubjectSimpleVO subjectSimpleVO) {
        SubjectPage subjectPage = new SubjectPage();
        BeanUtils.copyProperties(subjectSimpleVO, subjectPage);
        subjectPage.setProjectId(PROJECT_ID);
        subjectService.updateMain(subjectPage);
        //关键词绑定
        List<SearchWordVO> keywords = subjectSimpleVO.getKeywords();
        modifyKeyword(subjectSimpleVO.getId(), subjectSimpleVO.getSubjectName(), keywords);
    }

    @Override
    public List<SearchWordVO> subjectBindWordInfo(String subjectId) {
        List<SearchWordVO> wordInfoList = subjectKeywordsMapService.subjectBindWordInfo(subjectId);
        Map<String, SearchWordVO> map = wordInfoList.stream().collect(Collectors.toMap(SearchWordVO::getId, item -> item));
        LambdaQueryWrapper<SubjectKeywordsGroupRelation> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectKeywordsGroupRelation::getSubjectId, subjectId);
        List<SubjectKeywordsGroupRelation> relationList = subjectKeywordsGroupRelationService.list(queryWrapper);
        List<String> sortList = new ArrayList<>(relationList.size());
        for (SubjectKeywordsGroupRelation relation : relationList) {
            sortList.addAll(Arrays.asList(relation.getKeywordsGroupIds().split(",")));
            String relationType = relation.getRelationType();
            //paramStr：[{"title":"巴黎奥运会","value":"1830487575308136450"},{"title":"or","value":"|"},{"title":"栏目关键词","value":"1860252747367051265"}]
            String paramsStr = relation.getParamsStr();
            List<JSONObject> params = JSON.parseArray(paramsStr, JSONObject.class);
            if ("2".equals(relationType)) {
                if (params.size() > 1) {
                    for (int i = 1; i <= params.size() - 2; i += 2) {
                        JSONObject param1 = params.get(i);
                        String value = param1.get("value").toString();
                        String relationStr = null;
                        if ("&".equals(value)) {
                            relationStr = "AND";
                        } else if ("|".equals(value)) {
                            relationStr = "OR";
                        }
                        JSONObject param2 = params.get(i + 1);
                        String id = param2.get("value").toString();
                        map.get(id).setSearchLogicRelationship(relationStr);
                    }
                }
            } else if ("3".equals(relationType)) {
                String valueStr = params.get(0).get("value").toString();
                map.get(valueStr).setSearchLogicRelationship("AND");
                for (int i = 1; i < params.size() - 2; i += 2) {
                    JSONObject param = params.get(i + 1);
                    String id = param.get("value").toString();
                    map.get(id).setSearchLogicRelationship("AND");
                }
            }
        }
        List<SearchWordVO> wordList = new ArrayList<>(map.values());
        sortByAnotherList(wordList,sortList);
        return wordList;
    }

    //目标集合按照另一个集合的顺序排序
    private void sortByAnotherList(List<SearchWordVO> list, List<String> anotherList) {
        list.sort((o1, o2) -> {
            int index1 = anotherList.indexOf(o1.getId());
            int index2 = anotherList.indexOf(o2.getId());
            if (index1 != -1) {
                index1 = list.size() - index1;
            }
            if (index2 != -1) {
                index2 = list.size() - index2;
            }
            return index2 - index1;
        });
    }


    private void modifyKeyword(String subjectId, String subjectName, List<SearchWordVO> keywords) {
        LambdaQueryWrapper<SubjectKeywordsMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectKeywordsMap::getSubjectId, subjectId);
        List<SubjectKeywordsMap> bindList = subjectKeywordsMapService.list(queryWrapper);
        List<String> bindIdList = bindList.stream().map(SubjectKeywordsMap::getKeywordsId).collect(Collectors.toList());
        List<SearchWordVO> updateList = keywords.stream().filter(searchWordVO -> searchWordVO.getId() != null).collect(Collectors.toList());
        List<String> updateIdList = updateList.stream().map(SearchWordVO::getId).collect(Collectors.toList());
        List<String> removeIdList = new ArrayList<>();
        for (SearchWordVO searchWordVO : updateList) {
            String id = searchWordVO.getId();
            if (!bindIdList.contains(id)) {
                removeIdList.add(id);
            }
        }
        //编辑后保留下来的关键词
        List<SearchWordVO> retainList = modifyKeywordList(subjectName, keywords, removeIdList);
        //专题-关键词绑定关系
        List<SearchWordVO> addMapIdList = new ArrayList<>();
        for (SearchWordVO searchWordVO : retainList) {
            if (!updateIdList.contains(searchWordVO.getId())) {//过滤调已存在绑定关系的数据
                addMapIdList.add(searchWordVO);
            }
        }
        handlerSubjectKeywordMap(subjectId, addMapIdList, removeIdList);
        //专题下关键词之间的关系
        modifySubjectKeywordsGroupRelation(subjectId, retainList);
    }

    //保存词组关系
    private void modifySubjectKeywordsGroupRelation(String subjectId, List<SearchWordVO> retainList) {
        LambdaQueryWrapper<SubjectKeywordsGroupRelation> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectKeywordsGroupRelation::getSubjectId, subjectId);
        int count = subjectKeywordsGroupRelationService.count(queryWrapper);
        if (count > 0) {
            subjectKeywordsGroupRelationService.remove(queryWrapper);
        }
        List<SubjectKeywordsGroupRelation> subjectKeywordsGroupRelationList = new ArrayList<>();
        List<SearchWordVO> relationList = retainList.stream().filter(searchWordVO -> !"NOT".equalsIgnoreCase(searchWordVO.getSearchLogicRelationship())).collect(Collectors.toList());
        List<SearchWordVO> excludedList = retainList.stream().filter(searchWordVO -> "NOT".equalsIgnoreCase(searchWordVO.getSearchLogicRelationship())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(relationList)) {
            SubjectKeywordsGroupRelation subjectKeywordsGroupRelation = handlerGroupRelationMap(subjectId, relationList, "2");
            subjectKeywordsGroupRelationList.add(subjectKeywordsGroupRelation);
        }
        if (CollectionUtils.isNotEmpty(excludedList)) {
            SubjectKeywordsGroupRelation subjectKeywordsGroupRelation = handlerGroupRelationMap(subjectId, excludedList, "3");
            subjectKeywordsGroupRelationList.add(subjectKeywordsGroupRelation);
        }
        subjectKeywordsGroupRelationService.saveBatch(subjectKeywordsGroupRelationList);
    }

    //格式化 词组关系数据
    private SubjectKeywordsGroupRelation handlerGroupRelationMap(String subjectId, List<SearchWordVO> relationList, String relationType) {
        //relationList.sort(Comparator.comparing(SearchWordVO::getSearchLogicRelationship, Comparator.nullsFirst(Comparator.naturalOrder())));
        SubjectKeywordsGroupRelation subjectKeywordsGroupRelation = new SubjectKeywordsGroupRelation();
        subjectKeywordsGroupRelation.setSubjectId(subjectId);
        subjectKeywordsGroupRelation.setRelationType(relationType);
        List<String> keywordsGroupIds = new ArrayList<>();
        List<JSONObject> paramsStr = new ArrayList<>();
        String expression = null;
        if ("2".equals(relationType)) {
            StringBuilder expressionStr = new StringBuilder();
            for (SearchWordVO searchWordVO : relationList) {
                String id = searchWordVO.getId();
                String wordName = searchWordVO.getWordName();
                keywordsGroupIds.add(id);
                expressionStr.append("&").append(id);
                JSONObject relationParam = new JSONObject();
                relationParam.put("title", "AND");
                relationParam.put("value", "&");
                paramsStr.add(relationParam);
                JSONObject params = new JSONObject();
                params.put("title", wordName);
                params.put("value", id);
                paramsStr.add(params);
            }
            expression = expressionStr.substring(1);
            paramsStr = paramsStr.subList(1, paramsStr.size());
        } else if ("3".equals(relationType)) {
            StringBuilder expressionStr = new StringBuilder();
            for (int i = 0; i < relationList.size(); i++) {
                SearchWordVO searchWordVO = relationList.get(i);
                String id = searchWordVO.getId();
                String wordName = searchWordVO.getWordName();
                keywordsGroupIds.add(id);
                if (i == 0) {
                    expressionStr.append(id);
                    JSONObject params = new JSONObject();
                    params.put("title", wordName);
                    params.put("value", id);
                    paramsStr.add(params);
                } else {
                    String searchLogicRelationship = searchWordVO.getSearchLogicRelationship();
                    String relationStr = "|";
                    if ("AND".equals(searchLogicRelationship)) {
                        relationStr = "&";
                    } else if ("OR".equals(searchLogicRelationship)) {
                        relationStr = "|";
                    }
                    expressionStr.append(relationStr).append(id);
                    JSONObject relationParam = new JSONObject();
                    relationParam.put("title", searchLogicRelationship);
                    relationParam.put("value", relationStr);
                    paramsStr.add(relationParam);
                    JSONObject params = new JSONObject();
                    params.put("title", wordName);
                    params.put("value", id);
                    paramsStr.add(params);
                }
            }
            expression = expressionStr.toString();
        }
        subjectKeywordsGroupRelation.setKeywordsGroupIds(String.join(",", keywordsGroupIds));
        subjectKeywordsGroupRelation.setExpressionStr(expression);
        subjectKeywordsGroupRelation.setParamsStr(JSON.toJSONString(paramsStr));
        return subjectKeywordsGroupRelation;
    }

    //处理专题-关键词绑定关系
    private void handlerSubjectKeywordMap(String subjectId, List<SearchWordVO> addMapIdList, List<String> removeIdList) {
        if (CollectionUtils.isNotEmpty(addMapIdList)) {
            List<SubjectKeywordsMap> subjectKeywordsMapList = new ArrayList<>();
            for (SearchWordVO wordVO : addMapIdList) {
                SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
                subjectKeywordsMap.setKeywordsId(wordVO.getId());
                subjectKeywordsMap.setSubjectId(subjectId);
                subjectKeywordsMap.setType(String.valueOf(wordVO.getSearchScope()));
                String bindType;
                if ("NOT".equals(wordVO.getSearchLogicRelationship())) {
                    bindType = "3";
                } else {
                    bindType = "2";
                }
                subjectKeywordsMap.setBindingType(bindType);
                subjectKeywordsMapList.add(subjectKeywordsMap);
            }
            subjectKeywordsMapService.saveBatch(subjectKeywordsMapList);
        }
        if (CollectionUtils.isNotEmpty(removeIdList)) {
            LambdaQueryWrapper<SubjectKeywordsMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SubjectKeywordsMap::getSubjectId, subjectId);
            queryWrapper.in(SubjectKeywordsMap::getKeywordsId, removeIdList);
            subjectKeywordsMapService.remove(queryWrapper);
        }
    }

    //处理专题下关键词
    private List<SearchWordVO> modifyKeywordList(String subjectName, List<SearchWordVO> keywords, List<String> removeIdList) {
        List<SearchWordVO> realKeyWordList = new ArrayList<>();
        for (SearchWordVO wordVO : keywords) {
            String id = wordVO.getId();
            KeyWords keyWords = new KeyWords();
            keyWords.setKeyWord(wordVO.getSearchInfo());
            if (StringUtils.isEmpty(id)) {
                keyWords.setStatus("1");
                String wordsCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.KEY_WORDS_DEFAULT.getValue());
                String wordsName = subjectName + wordsCode.substring(wordsCode.indexOf("-"));
                keyWords.setWordsName(wordsName);
                keyWords.setWordsCode(wordsCode);
                keywordWordsService.save(keyWords);
                //关键词组-分类 关系绑定
                KeywordsTypeMap keywordsTypeMap = new KeywordsTypeMap();
                keywordsTypeMap.setTypeId(KEYWORDS_TYPE_ID);
                keywordsTypeMap.setKeywordsId(keyWords.getId());
                keywordsTypeMapService.save(keywordsTypeMap);
                //补充数据，后续逻辑使用
                wordVO.setId(keyWords.getId());
                wordVO.setWordName(wordsName);
            } else {
                keyWords.setId(id);
                keywordWordsService.updateById(keyWords);
            }
            realKeyWordList.add(wordVO);
        }
        if (CollectionUtils.isNotEmpty(removeIdList)) {
            keywordWordsService.removeByIds(removeIdList);
            LambdaQueryWrapper<KeywordsTypeMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(KeywordsTypeMap::getKeywordsId, removeIdList);
            keywordsTypeMapService.remove(queryWrapper);
        }
        return realKeyWordList;
    }
}
