package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.Event;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date: 2024-03-14
 * @Version: V1.0
 */
@Mapper
public interface EventMapper extends BaseMapper<Event> {

    List<SubjectKafkaVo> eventSubjectList();

    /**
     * 获取事件详情
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2024/4/12
     */
    EventVO queryInfo(@Param("eventId") String eventId);

    /**
     * 分页列表-后台管理
     *
     * @param eventName 事件名称
     * @param eventType 事件分类id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param order     排序字段
     * @param orderType 排序方式
     * @param offset    偏移量
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventManageVO> pageList(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                                 @Param("facePublic") Integer facePublic, @Param("publishStatus") Integer publishStatus,
                                 @Param("startTime") String startTime, @Param("endTime") String endTime,
                                 @Param("order") String order, @Param("orderType") String orderType,
                                 @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 总数量-后台管理
     *
     * @param eventName 事件名称
     * @param eventType 事件分类id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/4/8
     */
    Integer totalCount(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                       @Param("facePublic") Integer facePublic, @Param("publishStatus") Integer publishStatus,
                       @Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 分页列表-门户(全部)
     *
     * @param projectId  项目id
     * @param createBy   创建人
     * @param eventId    事件id
     * @param eventName  事件名称
     * @param eventTypes 事件分类id集合
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param type       类别(1-自定义标签;2-抽取标签)
     * @param order      排序字段
     * @param orderType  排序方式
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventFrontVO> frontAllPageList(@Param("projectId") String projectId, @Param("createBy") String createBy,
                                        @Param("eventId") String eventId, @Param("eventName") String eventName,
                                        @Param("eventTypes") List<String> eventTypes, @Param("labelField") String labelField,
                                        @Param("labelName") String labelName, @Param("type") Integer type,
                                        @Param("order") String order, @Param("orderType") String orderType,
                                        @Param("offset") Integer offset, @Param("pageSize") Integer pageSize,
                                        @Param("tenant") String tenant);

    /**
     * 总数量-门户(全部)
     *
     * @param projectId  项目id
     * @param createBy   创建人
     * @param eventId    事件id
     * @param eventName  事件名称
     * @param eventTypes 事件分类id集合
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param type       类别(1-自定义标签;2-抽取标签)
     * @author lkg
     * @date 2024/4/8
     */
    Integer frontAllCount(@Param("projectId") String projectId, @Param("createBy") String createBy,
                          @Param("eventId") String eventId, @Param("eventName") String eventName,
                          @Param("eventTypes") List<String> eventTypes, @Param("labelField") String labelField,
                          @Param("labelName") String labelName, @Param("type") Integer type,
                          @Param("tenant") String tenant);


    /**
     * 分页列表-门户(我的)
     *
     * @param projectId  项目id
     * @param createBy   创建人
     * @param eventName  事件名称
     * @param eventTypes 事件分类id集合
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param type       类别(1-自定义标签;2-抽取标签)
     * @param order      排序字段
     * @param orderType  排序方式
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventFrontVO> frontOwnerPageList(@Param("projectId") String projectId, @Param("createBy") String createBy, @Param("eventName") String eventName,
                                          @Param("eventTypes") List<String> eventTypes, @Param("labelField") String labelField,
                                          @Param("labelName") String labelName, @Param("type") Integer type,
                                          @Param("order") String order, @Param("orderType") String orderType,
                                          @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 总数量-门户(我的)
     *
     * @param projectId  项目id
     * @param createBy   创建人
     * @param eventName  事件名称
     * @param eventTypes 事件分类id集合
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param type       类别(1-自定义标签;2-抽取标签)
     * @author lkg
     * @date 2024/4/8
     */
    Integer frontOwnerCount(@Param("projectId") String projectId, @Param("createBy") String createBy, @Param("eventName") String eventName,
                            @Param("eventTypes") List<String> eventTypes, @Param("labelField") String labelField,
                            @Param("labelName") String labelName, @Param("type") Integer type);


    /**
     * 分页列表(专题分类)-新平台管理
     *
     * @param subjectCondition 筛选条件
     * @param offset           偏移量
     * @param pageSize         返回条数
     * @author lkg
     * @date 2024/4/28
     */
    List<EventNewPlatVO> newPlatPageList(@Param("subjectCondition") SubjectCondition subjectCondition, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 总数量(专题分类)-新平台管理
     *
     * @param subjectCondition 筛选条件
     * @author lkg
     * @date 2024/4/28
     */
    Integer newPlatCount(@Param("subjectCondition") SubjectCondition subjectCondition);

    /**
     * 分页列表(客户)-新平台管理
     *
     * @param subjectCondition 筛选条件
     * @param offset           偏移量
     * @param pageSize         返回条数
     * @author lkg
     * @date 2024/4/30
     */
    List<EventNewPlatVO> newPlatCustomerPageList(@Param("subjectCondition") SubjectCondition subjectCondition, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 总数量(客户)-新平台管理
     *
     * @param subjectCondition 筛选条件
     * @author lkg
     * @date 2024/4/28
     */
    Integer newPlatCustomerCount(@Param("subjectCondition") SubjectCondition subjectCondition);

    /**
     * 热点事件列表-前10
     *
     * @param projectId 项目id
     * @param createBy  创建人
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      分类(1-按发布时间;2.按热度)
     * @param offset    偏移量
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventTopVO> topEventList(@Param("projectId") String projectId, @Param("createBy") String createBy,
                                  @Param("startTime") String startTime, @Param("endTime") String endTime,
                                  @Param("type") Integer type,
                                  @Param("offset") Integer offset, @Param("pageSize") Integer pageSize,
                                  @Param("tenant") String tenant);

    List<SubjectKafkaVo> processList(@Param("disableDate") Date disableDate);

    /**
     * 根据地域获取事件信息列表
     *
     * @param name 地域名称
     * @author lkg
     * @date 2024/4/10
     */
    List<EventRegionVO> listByRegion(@Param("projectId") String projectId, @Param("createBy") String createBy, @Param("type") Integer type, @Param("name") String name,
                                     @Param("tenant") String tenant);

    /**
     * 公开且发布的事件信息集合
     *
     * @param projectId   项目id
     * @param createBy    创建人
     * @param eventIdList 事件id集合
     * @param size        数量
     * @author lkg
     * @date 2024/4/10
     */
    List<EventExcelVO> frontAllList(@Param("projectId") String projectId, @Param("createBy") String createBy, @Param("eventIdList") List<String> eventIdList,
                                    @Param("eventName") String eventName,@Param("eventTypes") List<String> eventTypes, @Param("labelField") String labelField,
                                    @Param("labelName") String labelName, @Param("type") Integer type,@Param("size") Integer size,
                                    @Param("tenant") String tenant);

    /**
     * 默认创建的，公开且发布的事件信息集合
     *
     * @param projectId   项目id
     * @param createBy    创建人
     * @param eventIdList 事件id集合
     * @param size        数量
     * @author lkg
     * @date 2024/4/10
     */
    List<EventExcelVO> frontOwnerList(@Param("projectId") String projectId, @Param("createBy") String createBy, @Param("eventIdList") List<String> eventIdList,
                                      @Param("eventName") String eventName,@Param("eventTypes") List<String> eventTypes, @Param("labelField") String labelField,
                                      @Param("labelName") String labelName, @Param("type") Integer type,@Param("size") Integer size);

    /**
     * 模型信息列表
     *
     * @author lkg
     * @date 2024/4/11
     */
    List<ModelVO> modelList();

    /**
     * 获取事件信息集合
     *
     * @param eventIdList 事件id集合
     * @author lkg
     * @date 2024/4/12
     */
    List<EventVO> eventList(@Param("eventIdList") List<String> eventIdList, @Param("tenant")String tenant);

    /**
     * 专题绑定关键词数量
     *
     * @param idList 专题id集合
     * @author lkg
     * @date 2024/4/28
     */
    List<SubjectPage> bindKeywordCountList(@Param("idList") List<String> idList);

    /**
     * 专题绑定的信息源集合
     *
     * @param subjectIds 专题id
     * @author lkg
     * @date 2024/4/24
     */
    List<SubjectSourceVO> bindSourceList(@Param("subjectIds") List<String> subjectIds);

    /**
     * 专题绑定的信息源集合
     *
     * @param subjectIds 专题id
     * @author lkg
     * @date 2024/4/24
     */
    List<SubjectSourceVO> excludeSourceList(@Param("subjectIds") List<String> subjectIds);

    /**
     * 项目列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<Node> projectList(@Param("userId") String userId, @Param("customerId") String customerId);

    /**
     * 分类下的事件id集合
     *
     * @param userId  用户id
     * @param typeIds 分类id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> selectSubjectByTypeIds(@Param("userId") String userId, @Param("typeIds") List<String> typeIds);

    /**
     * 用户下的事件id集合
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/5/6
     */
    List<String> selectSubjectWithCustomer(@Param("userId") String userId, @Param("customerId") String customerId);

    /**
     * 专题绑定关键词的id集合
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> bindKeyWordsIdList(@Param("subjectIds") List<String> subjectIds);

    /**
     * 专题绑定模型信息列表
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<LabelModelVo> selectLabelModelBySubjectId(@Param("subjectIds") List<String> subjectIds);

    /**
     * 企业标签下的企业信用代码集合
     *
     * @param labelIds 企业标签id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> codesByLabels(@Param("labelIds") List<String> labelIds);

    /**
     * 判断信息源是否在专题绑定的信息源组下
     *
     * @param subjectId 专题id
     * @param sourceId  信息源id
     * @author lkg
     * @date 2024/4/24
     */
    int ynBelowBindGroup(@Param("subjectId") String subjectId, @Param("sourceId") String sourceId);

    /**
     * 判断信息源是否在专题排除的信息源组下
     *
     * @param subjectId 专题id
     * @param sourceId  信息源id
     * @author lkg
     * @date 2024/4/24
     */
    int ynBelowExcludeGroup(@Param("subjectId") String subjectId, @Param("sourceId") String sourceId);


    /**
     * 专题绑定关键词信息-分页列表
     *
     * @param subjectIds 专题id集合
     * @param groupName  词组名称
     * @param wordName   关键词名称
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/5/7
     */
    List<KeyWordsPage> bindKeyWordsList(@Param("subjectIds") List<String> subjectIds,
                                        @Param("groupName") String groupName, @Param("wordName") String wordName,
                                        @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 专题绑定关键词信息-总数量
     *
     * @param subjectIds 专题id集合
     * @param groupName  词组名称
     * @param wordName   关键词名称
     * @author lkg
     * @date 2024/5/7
     */
    Long bindKeyWordsCount(@Param("subjectIds") List<String> subjectIds, @Param("groupName") String groupName, @Param("wordName") String wordName);
}
