package com.zzsn.event.controller;

import com.zzsn.event.entity.EventCategory;
import com.zzsn.event.service.IEventCategoryService;
import com.zzsn.event.constant.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 事件分类
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Slf4j
@Api(tags="事件分类")
@RestController
@RequestMapping("/eventCategory")
public class EventCategoryController {

	@Autowired
	private IEventCategoryService eventCategoryService;
	/**
	 * 获取树状数据
	 *
	 * @return
	 */
	@ApiOperation(value="获取树状数据", notes="获取树状数据")
	@GetMapping(value = "/treeData")
	public Result<?> treeData() {
		Map<String, List<EventCategory>> collect = eventCategoryService.list().stream().collect(Collectors.groupingBy(EventCategory::getPid));
		EventCategory parent = EventCategory.builder().id("0").typeName("所有").hasChild(1).build();
		buildData(parent,collect);
		return Result.OK(parent);
	}

	private void buildData(EventCategory parent, Map<String, List<EventCategory>> collect) {
		if(parent.getHasChild()==1){
			parent.setChildren(collect.get(parent.getId()));
			collect.remove(parent.getId());
			for (EventCategory child : parent.getChildren()) {
				buildData(child,collect);
			}
		}
	}

}
