package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.entity.arrange.ClbModelArrange;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 专题分页实体
 *
 * @author lkg
 * @date 2025/3/25
 */
@Data
public class SubjectPageVO {

    /**专题id*/
    private String id;
    /**专题编码*/
    private String subjectCode;
    /**专题名称*/
    private String subjectName;
    /**状态(1-启用;0-禁用)*/
    private Integer status;
    /**专题所属分类名称*/
    private String subjectTypeName;
    /**专题所属项目名称*/
    private String projectName;
    private String dataScope;

    /**信息总数量*/
    private Integer totalNum;
    /**待审核数量*/
    private Integer unCheckNum;
    /**绑定信息源数量*/
    private Integer bindSourceNum;
    /**绑定关键词组数量*/
    private Integer bindKeywordNum;
    /**最新数据日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date latestDataDate;
    /**预估状态*/
    private String estimateStatus;

    /**主题绑定流程信息*/
    private List<ClbModelArrange> clbModelArranges;
}
