package com.zzsn.event.vo;

import com.zzsn.event.vo.es.Label;
import lombok.Data;

import java.util.List;

@Data
public class InfoDataSearchCondition {

    //subjectId是否专题id(1-是;0-否)
    private String isSubject = "1";
    //专题id/专题分类id
    private String subjectId;

    //搜索时，全部情况下，，搜索传值
    private String search;

    //专题标题
    private String title;

    //专题摘要
    private String summary;

    //内容
    private String content;

    //来源
    private String origin;

    //搜索范围(all、title、content、origin)
    private String searchScope;
    //搜索词
    private String searchWord;

    //时间格式化
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    //发布时间
    private String publishDate;

    //开始时间
    private String startTime;

    //结束时间
    private String endTime;

    /*-----------------单个专题时，起效-----------*/
    //专题配置的开始时间
    private String configStartTime;
    //专题配置的结束时间
    private String configEndTime;
    /*-----------------单个专题时，起效-----------*/

    //专题库类型(对应字典编码为【Thematic_Library】的数据字典值)
    private List<Integer> classificationType;

    /**原创性(0-非原创;1-原创;2-疑似)*/
    private String originality;

    //资讯状态-研究中心(0-全部;1-模型推荐;2-精选;3-待定;4-移除),和auditStatus互斥
    private Integer status;

    //平台-审核状态(null-全部;1-通过;2-未审核;3-暂定;4-删除;5-免审核)
    private Integer auditStatus;
    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;
    //删除标记(1:删除；0:未删除)
    private Integer deleteFlag = 0;
    //是否免审核(1-是;0-否)
    private Integer isFreeCheck;

    //关联标签名称
    private String labelName;

    //是否专题下所有信息源(1-是;0-否)
    private String isAll;

    //专题分类(1-专题;2-事件)
    private Integer category = 1;
    //是否视频 "video"
    private String video;

    //爬虫类型
    private String crawler;

    //组合标签查询(不同类标签之间是与的关系，同一类标签之间是或的关系)，示例: "a1,a2;c1,c2"
    private String composeSearchLabelIds;

    /**----企业类标签筛选----**/
    //企业类标签id集合
    private List<String> enterpriseLabelTypeIds;
    //企业信用代码集合
    private List<String> socialCreditCodeList;
    /**----企业类标签id集合----**/
    //关联标签值id集合
    private List<String> labelIds;
    //正负面标签
    private String tendencyLabelId;
    //地域标签id集合
    private List<String> areaLabelIds;
    //关联信息源标签集合
    private List<Label> labelList;
    //信息源id
    private String sourceId;
    //搜索词信息集合-研究中心
    private List<SearchWordVO> searchWordList;
    /*------高级查询条件---start-------------------*/
    //规则
    private String superQueryMatchType;
    //条件（url转码后的json）
    private String superQueryParams;
    /*------高级查询条件---end-------------------*/

    //报告id (报告任务场景，根据报告id获取资讯的查询条件)
    private String reportId;


    //数据集id，保存数据集时使用-研究中心
    private String dataSetId;

    //待删除的标签id(多个用逗号隔开)-研究中心
    private String removeRelationId;

    //关键词信息；推荐信息源时使用-研究中心
    private List<String> wordsList;


    //得分范围-研究中心
    //最小得分
    private Integer minScore;
    //最大得分
    private Integer maxScore;

    //正文长度-研究中心
    //最小长度
    private Integer minContentLength;
    //最大长度
    private Integer maxContentLength;

    //es查询字段数组
    private String[] fetchFields;
    //排除字段数组
    private String[] excludeFields = new String[]{"content", "contentWithTag","contentRaw", "contentWithTagRaw"};

    //排序参数
    //排序字段
    private String column;
    //排序方式 asc/desc
    private String order = "desc";
    //置顶排序是否起效(1-是;0-否)
    private Integer topSortValid = 0;

    //分页参数
    //当前页
    private Integer pageNo = 1;
    //每页返回条数
    private Integer pageSize = 10;

    //选择前num条数据
    private Integer num;

    //资讯id集合
    private List<String> ids;

    //关联标签名称
    private String labelMark;

    /*------资讯导出类参数-研究中心---start-------------------*/
    //导出方式(1-摘要;2-正文)
    private Integer exportType;
    /*------资讯导出类参数---end-------------------*/


    /*------专题分析类参数---start-------------------*/
    //聚合分组类型-按日期集合分析时使用
    private String groupType;
    //信息源id集合-统计分析资讯量最多的信息源时使用
    private List<String> sourceIdList;
    //聚合包含的字段值的集合
    private String[] includeValues;
    //聚合排除的字段值的集合
    private String[] excludeValues;
    /*------专题分析类参数---end-------------------*/


    /*------添加至精选时，主题列表---start-------------------*/
    private List<Label> themeList;
    /*------添加至精选时，主题列表---end-------------------*/


    /*------待删除的关键词列表---start-------------------*/
    private List<String> keywordList;
    /*------待删除的关键词列表---end-------------------*/

    /*-----字符串替换---start-------------------*/
    private String replaceWord;
    /*------字符串替换---end-------------------*/

    /*-----打标签---start-------------------*/
    private List<Label> markTags;
    /*------打标签---end-------------------*/
    /**
     * 本次任务使用的流程id
     */
    private String flowId;
}
