package com.zzsn.event.config.interceptor;

import com.zzsn.event.util.RequestUtil;
import com.zzsn.event.util.TenantHelper;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CustomInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        // 获取请求头数据 区分测试和正式
        String tenant = RequestUtil.getTenantByRequest(request);
        TenantHelper.setTenant(tenant);
        // 返回 true 继续处理请求，返回 false 则中断请求
        return true;
    }
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TenantHelper.getInstance().close();
        HandlerInterceptor.super.afterCompletion(request, response, handler, ex);
    }

}
