package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.Event;
import com.zzsn.event.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date: 2024-03-14
 * @Version: V1.0
 */
@Mapper
public interface EventMapper extends BaseMapper<Event> {

    List<SubjectKafkaVo> eventSubjectList();

    /**
     * 分页列表-后台管理
     *
     * @param eventName 事件名称
     * @param eventType 事件分类id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param order     排序字段
     * @param orderType 排序方式
     * @param offset    偏移量
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventManageVO> pageList(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                                 @Param("startTime") String startTime, @Param("endTime") String endTime,
                                 @Param("order") String order, @Param("orderType") String orderType,
                                 @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 总数量-后台管理
     *
     * @param eventName 事件名称
     * @param eventType 事件分类id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2024/4/8
     */
    Integer totalCount(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                       @Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 分页列表-后台管理
     *
     * @param eventName  事件名称
     * @param eventType  事件分类id
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param type       类别(1-自定义标签;2-抽取标签)
     * @param order      排序字段
     * @param orderType  排序方式
     * @param offset     偏移量
     * @param pageSize   返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventFrontVO> frontPageList(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                                     @Param("labelField") String labelField, @Param("labelName") String labelName,
                                     @Param("type") Integer type,
                                     @Param("order") String order, @Param("orderType") String orderType,
                                     @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 总数量-后台管理
     *
     * @param eventName  事件名称
     * @param eventType  事件分类id
     * @param labelField 搜索字段
     * @param labelName  搜索词
     * @param type       类别(1-自定义标签;2-抽取标签)
     * @author lkg
     * @date 2024/4/8
     */
    Integer frontTotalCount(@Param("eventName") String eventName, @Param("eventType") Integer eventType,
                            @Param("labelField") String labelField, @Param("labelName") String labelName,
                            @Param("type") Integer type);

    /**
     * 热点事件列表-前10
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param type      分类(1-按发布时间;2.按热度)
     * @param offset    偏移量
     * @param pageSize  返回条数
     * @author lkg
     * @date 2024/4/8
     */
    List<EventTopVO> topEventList(@Param("startTime") String startTime, @Param("endTime") String endTime,
                                  @Param("type") Integer type,
                                  @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    List<SubjectKafkaVo> processList(@Param("disableDate") Date disableDate);

    /**
     * 根据地域获取事件信息列表
     *
     * @param name 地域名称
     * @author lkg
     * @date 2024/4/10
     */
    List<EventRegionVO> listByRegion(@Param("type") Integer type, @Param("name") String name);

    /**
     * 公开且发布的事件信息集合
     *
     * @param eventIdList 事件id集合
     * @param size        数量
     * @author lkg
     * @date 2024/4/10
     */
    List<EventExcelVO> frontList(@Param("eventIdList") List<String> eventIdList, @Param("size") Integer size);

    /**
     * 模型信息列表
     *
     * @author lkg
     * @date 2024/4/11
     */
    List<ModelVO> modelList();
}
