package com.zzsn.event.xxljob.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.Event;
import com.zzsn.event.enums.InfoSourceStatusEnum;
import com.zzsn.event.enums.XxljobInfoStatusEnum;
import com.zzsn.event.util.CronUtil;
import com.zzsn.event.vo.KeyWordsDTO;
import com.zzsn.event.xxljob.entity.XxlJobGroup;
import com.zzsn.event.xxljob.entity.XxlJobInfo;
import com.zzsn.event.xxljob.mapper.XxlJobInfoMapper;
import com.zzsn.event.xxljob.service.IXxlJobGroupService;
import com.zzsn.event.xxljob.service.IXxlJobInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * @Description: xxl_job_info
 * @Author: jeecg-boot
 * @Date: 2021-06-09
 * @Version: V1.0
 */
@Slf4j
@Service
@DS("multi-datasource1")
public class XxlJobInfoServiceImpl extends ServiceImpl<XxlJobInfoMapper, XxlJobInfo> implements IXxlJobInfoService {
    @Autowired
    IXxlJobInfoService xxlJobInfoService;
    @Autowired
    IXxlJobGroupService xxlJobGroupService;

    //关键词执行器
    private static final String keyWordsExecutorAppname = "key-words-executor";
    private static final String keyWordsHandlerName = "keyWordsHandler";

    //专题执行器
    private static final String subjectExecutorAppname = "subject-executor";
    private static final String subjectHandlerName = "subjectHandler";

    /**
     * 关键词增加任务
     */
    @Override
    public void keyWordsInsert(KeyWordsDTO keyWordsDTO) {
        deleteByInfosourceCode(keyWordsDTO.getWordsCode());

        QueryWrapper<XxlJobGroup> xxlJobGroupQueryWrapper = new QueryWrapper<>();
        xxlJobGroupQueryWrapper.eq("app_name", keyWordsExecutorAppname);
        xxlJobGroupQueryWrapper.last("limit 1");
        XxlJobGroup xxlJobGroup = xxlJobGroupService.getOne(xxlJobGroupQueryWrapper);

        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        if (ObjectUtils.isEmpty(xxlJobGroup)) {
            log.error("信息源执行器没有找到, 执行器名称=[{}]", keyWordsExecutorAppname);
            // 默认执行器
            xxlJobInfo.setJobGroup(-1L);
        } else {
            // 执行器
            xxlJobInfo.setJobGroup(xxlJobGroup.getId());
        }
        //获取随机时间的间隔
        String cron = CronUtil.getRandomCron();
        xxlJobInfo.setJobCron(cron);

        // 任务描述
        xxlJobInfo.setJobDesc("任务名称为：" + keyWordsDTO.getWordsName() + "；关键词编码为：" + keyWordsDTO.getWordsCode());
        xxlJobInfo.setAddTime(new Date());
        xxlJobInfo.setUpdateTime(new Date());
        xxlJobInfo.setAuthor("task-infosource-task-modify");
        // 需要在yaml做配置
        xxlJobInfo.setAlarmEmail("");
        // 路由策略: 第一个
        xxlJobInfo.setExecutorRouteStrategy("FIRST");
        // JobHandler
        xxlJobInfo.setExecutorHandler(keyWordsHandlerName);
        // 任务参数
        xxlJobInfo.setExecutorParam(keyWordsDTO.getWordsCode());
        // 阻塞处理策略: 单机串行
        xxlJobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        // 运行模式
        xxlJobInfo.setGlueType("BEAN");
        // 任务超时时间
        xxlJobInfo.setExecutorTimeout(0);
        // 失败重试次数
        xxlJobInfo.setExecutorFailRetryCount(0);
        xxlJobInfo.setGlueUpdatetime(new Date());
        if (keyWordsDTO.getStatus().equals(InfoSourceStatusEnum.ENABLE.getvalue())) {
            xxlJobInfo.setTriggerStatus(XxljobInfoStatusEnum.RUNNING.getvalue());
        } else {
            xxlJobInfo.setTriggerStatus(XxljobInfoStatusEnum.STOP.getvalue());
        }
        // 关联的信息源编码
        xxlJobInfo.setInfoSourceCode(keyWordsDTO.getWordsCode());
        xxlJobInfoService.save(xxlJobInfo);

    }

    /**
     * 关键词删除任务
     */
    @Override
    public void keyWordsUpdate(List<String> keyWordsCodes, String status) {
        if (StringUtils.isEmpty(status)) {
            status = "0";
        }
        baseMapper.updateInfo(keyWordsCodes, status);
        log.info("修改xxljob任务成功, keyWordsCode=[{}]", keyWordsCodes.toString());
    }

    @Override
    public void cronUpdate(String code, String cron) {
        baseMapper.updateCron(code, cron);
    }


    /**
     * 关键词更改任务
     */
    @Override
    public void keyWordsDelete(KeyWordsDTO keyWordsDTO) {
        deleteByInfosourceCode(keyWordsDTO.getWordsCode());
    }

    /**
     * 关键词增加任务
     */
    @Override
    public void subjectInsert(Event event) {
        deleteByInfosourceCode(event.getEventCode());
        QueryWrapper<XxlJobGroup> xxlJobGroupQueryWrapper = new QueryWrapper<>();
        xxlJobGroupQueryWrapper.eq("app_name", subjectExecutorAppname);
        xxlJobGroupQueryWrapper.last("limit 1");
        XxlJobGroup xxlJobGroup = xxlJobGroupService.getOne(xxlJobGroupQueryWrapper);
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        if (ObjectUtils.isEmpty(xxlJobGroup)) {
            log.error("信息源执行器没有找到, 执行器名称=[{}]", subjectExecutorAppname);
            // 默认执行器
            xxlJobInfo.setJobGroup(-1L);
        } else {
            // 执行器
            xxlJobInfo.setJobGroup(xxlJobGroup.getId());
        }
        xxlJobInfo.setJobCron(event.getCron());
        // 任务描述
        xxlJobInfo.setJobDesc("任务名称为：" + event.getEventName() + "；专题编码为：" + event.getEventCode());
        xxlJobInfo.setAddTime(new Date());
        xxlJobInfo.setUpdateTime(new Date());
        xxlJobInfo.setAuthor("admin");
        // 需要在yaml做配置
        xxlJobInfo.setAlarmEmail("");
        // 路由策略: 第一个
        xxlJobInfo.setExecutorRouteStrategy("FIRST");
        // JobHandler
        xxlJobInfo.setExecutorHandler(subjectHandlerName);
        // 任务参数
        xxlJobInfo.setExecutorParam(event.getEventCode());
        // 阻塞处理策略: 单机串行
        xxlJobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        // 运行模式
        xxlJobInfo.setGlueType("BEAN");
        // 任务超时时间
        xxlJobInfo.setExecutorTimeout(0);
        // 失败重试次数
        xxlJobInfo.setExecutorFailRetryCount(0);
        xxlJobInfo.setGlueUpdatetime(new Date());
        if (event.getStatus() != null && event.getStatus() == 1) {
            xxlJobInfo.setTriggerStatus(XxljobInfoStatusEnum.RUNNING.getvalue());
        } else {
            xxlJobInfo.setTriggerStatus(XxljobInfoStatusEnum.STOP.getvalue());
        }
        // 关联的信息源编码
        xxlJobInfo.setInfoSourceCode(event.getEventCode());
        xxlJobInfoService.save(xxlJobInfo);

    }

    /**
     * 关键词删除任务
     */
    @Override
    public void subjectUpdate(List<String> subjectCodes, String status) {
        if (StringUtils.isEmpty(status)) {
            status = "0";
        }
        baseMapper.updateInfo(subjectCodes, status);
        log.info("修改xxljob任务成功, keyWordsCode=[{}]", subjectCodes.toString());
    }

    /**
     * 关键词更改任务
     */
    @Override
    public void subjectDelete(Event event) {
        deleteByInfosourceCode(event.getEventCode());
    }


    @Override
    public void deleteByInfosourceCode(String infosourceCode) {
        // 这里必须判空，否则会误删很多task
        if (!ObjectUtils.isEmpty(infosourceCode)) {
            QueryWrapper<XxlJobInfo> xxlJobInfoQueryWrapper = new QueryWrapper<>();
            xxlJobInfoQueryWrapper.eq("info_source_code", infosourceCode);
            xxlJobInfoService.remove(xxlJobInfoQueryWrapper);
        }
    }

}
