package com.zzsn.event.controller;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.config.SubjectSyncConfig;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.*;
import com.zzsn.event.service.*;
import com.zzsn.event.util.encryption.AesEncryptUtil;
import com.zzsn.event.vo.SubjectKeywordsMap;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Description: 平台间专题数据同步
 * @Author: yanxin
 * @Date: 2023-06-12
 * @Version: V1.0
 */
@Api(tags = "平台间专题数据同步")
@RestController
@RequestMapping("/sync")
@Slf4j
public class SubjectSyncController {
    @Autowired
    private SubjectSyncConfig syncConfig;
    /**
     * 专题直接关联部分begin
     */
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private SubjectKeywordsService subjectKeywordsService;
    @Autowired
    private ISubjectKeywordsMapService subjectKeywordsMapService;
    @Autowired
    private ISubjectModelMapService subjectModelMapService;
    @Autowired
    private ISubjectSearchEnginesMapService subjectSearchEnginesMapService;
    /**专题直接关联部分end*/
    /**
     * 专题分类部分begin
     */
    @Autowired
    private ISubjectTypeMapService subjectTypeMapService;
    @Autowired
    private ISubjectTypeService subjectTypeService;
    /**专题分类部分end*/
    /**
     * 信息源以及信息源组部分begin
     */
    @Autowired
    private IInfoSourceService infoSourceService;
    @Autowired
    private ISubjectInfoSourceMapService subjectInfoSourceMapService;
    @Autowired
    private InfoSourceGroupService infoSourceGroupService;
    @Autowired
    private IInfoSourceGroupMapService infoSourceGroupMapService;
    @Autowired
    private IGroupTypeService groupTypeService;
    @Autowired
    private IGroupTypeMapService groupTypeMapService;
    /**信息源以及信息源组部分end*/
    @GetMapping(value = "/getConfigs")
    public Result<?> getConfigs() {
        List<SubjectSyncConfig.ConfigVo> configVos = JSONArray.parseArray(JSONArray.toJSONString(syncConfig.getConfigs()), SubjectSyncConfig.ConfigVo.class);
        return Result.OK(configVos);
    }
    @GetMapping(value = "/getProjectTreeList")
    public Object getProjectTreeList(@RequestParam(name="code") String code) throws Exception {
        Optional<SubjectSyncConfig.Config> first = syncConfig.getConfigs().stream().filter(config -> code.equals(config.getCode())).findFirst();
        if(!first.isPresent()){
            return Result.FAIL("未找到对应配置");
        }
        SubjectSyncConfig.Config config = first.get();
        //获取登陆token
        String post = HttpUtil.get(config.getDomain() + config.getLoginUrl()+"?username="+ AesEncryptUtil.encrypt(config.getUsername())+"&password="+AesEncryptUtil.encrypt(config.getPassword()));
        String token = JSON.parseObject(post).getString("result");
        //查询专题配置
        HttpHeaders headers = new HttpHeaders();
        headers.add(Constants.HEADER_KEY, token);
        String body = HttpRequest.get(config.getDomain() + config.getSubjectListUrl()).header(headers).execute().body();
        return JSONObject.parseObject(body);
    }
    /**
     * 接收专题信息并更新本地库
     * @param subjectId
     * @return
     */
    @GetMapping(value = "/findSubjectData")
    public Result<?> findSubjectData(@RequestParam(name="subjectId") String subjectId) {
        SubjectAboutTable aboutTable = new SubjectAboutTable();
        //专题直接关联部分
        Subject subject = subjectService.getById(subjectId);
        if(subject == null){
            return Result.FAIL("专题不存在");
        }
        aboutTable.getSubject().add(subject);
        aboutTable.getSubjectKeywords().addAll(subjectKeywordsService.list(Wrappers.lambdaQuery(SubjectKeywords.class).eq(SubjectKeywords::getSubjectId,subjectId)));
        aboutTable.getSubjectKeywordsMap().addAll(subjectKeywordsMapService.list(Wrappers.lambdaQuery(SubjectKeywordsMap.class).eq(SubjectKeywordsMap::getSubjectId,subjectId)));
        aboutTable.getSubjectModelMap().addAll(subjectModelMapService.list(Wrappers.lambdaQuery(SubjectModelMap.class).eq(SubjectModelMap::getSubjectId,subjectId)));
        aboutTable.getSubjectSearchEnginesMap().addAll(subjectSearchEnginesMapService.list(Wrappers.lambdaQuery(SubjectSearchEnginesMap.class).eq(SubjectSearchEnginesMap::getSubjectId,subjectId)));
        //专题分类部分
        aboutTable.getSubjectTypeMap().addAll(subjectTypeMapService.list(Wrappers.lambdaQuery(SubjectTypeMap.class).eq(SubjectTypeMap::getSubjectId,subjectId)));
        if(aboutTable.getSubjectTypeMap().size()>0){
            List<String> typeIds = aboutTable.getSubjectTypeMap().stream().map(SubjectTypeMap::getTypeId).collect(Collectors.toList());
            while (true){
                Iterator<String> iterator = typeIds.iterator();
                while (iterator.hasNext()){
                    String next = iterator.next();
                    if(StringUtils.isEmpty(next) || "0".equals(next)){
                        iterator.remove();
                    }
                }
                if(typeIds.size()<=0){
                    break;
                }
                List<SubjectType> list = subjectTypeService.list(Wrappers.lambdaQuery(SubjectType.class).in(SubjectType::getId, typeIds));
                typeIds = list.stream().map(SubjectType::getPid).collect(Collectors.toList());
                aboutTable.getSubjectType().addAll(list);
            }
        }
        //信息源以及信息源组部分begin
        aboutTable.getSubjectInfoSourceMap().addAll(subjectInfoSourceMapService.list(Wrappers.lambdaQuery(SubjectInfoSourceMap.class).eq(SubjectInfoSourceMap::getSubjectId,subjectId).eq(SubjectInfoSourceMap::getType,2)));
        List<String> groupIds = aboutTable.getSubjectInfoSourceMap().stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList());
        if(groupIds.size()>0){
            aboutTable.getInfoSourceGroup().addAll(infoSourceGroupService.list(Wrappers.lambdaQuery(InfoSourceGroup.class).in(InfoSourceGroup::getId,groupIds)));
            aboutTable.getInfoSourceGroupMap().addAll(infoSourceGroupMapService.list(Wrappers.lambdaQuery(InfoSourceGroupMap.class).in(InfoSourceGroupMap::getGroupId,groupIds)));
            List<String> sourceIds = aboutTable.getInfoSourceGroupMap().stream().map(InfoSourceGroupMap::getSourceId).collect(Collectors.toList());
            aboutTable.getInfoSource().addAll(infoSourceService.list(Wrappers.lambdaQuery(InfoSource.class).in(InfoSource::getId,sourceIds)));
            aboutTable.getGroupTypeMap().addAll(groupTypeMapService.list(Wrappers.lambdaQuery(GroupTypeMap.class).in(GroupTypeMap::getGroupId,groupIds)));
            if(aboutTable.getGroupTypeMap().size()>0){
                List<String> typeIds = aboutTable.getGroupTypeMap().stream().map(GroupTypeMap::getTypeId).collect(Collectors.toList());
                while (true){
                    Iterator<String> iterator = typeIds.iterator();
                    while (iterator.hasNext()){
                        String next = iterator.next();
                        if(StringUtils.isEmpty(next) || "0".equals(next)){
                            iterator.remove();
                        }
                    }
                    if(typeIds.size()<=0){
                        break;
                    }
                    List<GroupType> list = groupTypeService.list(Wrappers.lambdaQuery(GroupType.class).in(GroupType::getId, typeIds));
                    typeIds = list.stream().map(GroupType::getPid).collect(Collectors.toList());
                    aboutTable.getGroupType().addAll(list);
                }
            }
        }
        return Result.OK(aboutTable);
    }

    /**
     * 查询并更新本地专题信息
     *
     * @return
     */
    @GetMapping(value = "/findAndSyncSubjectData")
    public Result<?> findAndSyncSubjectData(@RequestParam(name="code") String code,
                                            @RequestParam(name="subjectId") String subjectId,
                                            @RequestParam(name="environment",defaultValue = "") String environment) {
        try {
            Optional<SubjectSyncConfig.Config> first = syncConfig.getConfigs().stream().filter(config -> code.equals(config.getCode())).findFirst();
            if(!first.isPresent()){
                return Result.FAIL("未找到对应配置");
            }
            SubjectSyncConfig.Config config = first.get();
            //获取登陆token
            String post = HttpUtil.get(config.getDomain() + config.getLoginUrl()+"?username="+ AesEncryptUtil.encrypt(config.getUsername())+"&password="+AesEncryptUtil.encrypt(config.getPassword()));
            String token = JSON.parseObject(post).getString("result");
            //查询专题配置
            HttpHeaders headers = new HttpHeaders();
            headers.add(Constants.HEADER_KEY, token);
            String body = HttpRequest.get(config.getDomain() + config.getFindDataUrl() + "?subjectId=" + subjectId).header(headers).execute().body();
            if(JSON.parseObject(body).getInteger("code") != 200){
                log.error("专题：{}信息查询失败：{}",subjectId,body);
                return Result.FAIL("专题信息查询失败");
            }
            SubjectAboutTable aboutTable = JSON.parseObject(JSON.parseObject(body).getString("result"),SubjectAboutTable.class);
            if(aboutTable.getSubject()!=null && aboutTable.getSubject().size()>0){
                //同步后默认专题为未启用状态
                Subject subject = aboutTable.getSubject().get(0);
                subject.setStatus(0);
                subject.setEnvironment(environment);
                subjectService.saveOrUpdateBatch(aboutTable.getSubject());
            }
            if(aboutTable.getSubjectKeywords()!=null && aboutTable.getSubjectKeywords().size()>0){
                subjectKeywordsService.saveOrUpdateBatch(aboutTable.getSubjectKeywords());
            }
            if(aboutTable.getSubjectKeywordsMap()!=null && aboutTable.getSubjectKeywordsMap().size()>0){
                subjectKeywordsMapService.saveOrUpdateBatch(aboutTable.getSubjectKeywordsMap());
            }
            if(aboutTable.getSubjectModelMap()!=null && aboutTable.getSubjectModelMap().size()>0){
                subjectModelMapService.saveOrUpdateBatch(aboutTable.getSubjectModelMap());
            }
            if(aboutTable.getSubjectSearchEnginesMap()!=null && aboutTable.getSubjectSearchEnginesMap().size()>0){
                subjectSearchEnginesMapService.saveOrUpdateBatch(aboutTable.getSubjectSearchEnginesMap());
            }
            if(aboutTable.getSubjectTypeMap()!=null && aboutTable.getSubjectTypeMap().size()>0){
                subjectTypeMapService.saveOrUpdateBatch(aboutTable.getSubjectTypeMap());
            }
            if(aboutTable.getSubjectType()!=null && aboutTable.getSubjectType().size()>0){
                subjectTypeService.saveOrUpdateBatch(aboutTable.getSubjectType());
            }
            if(aboutTable.getInfoSource()!=null && aboutTable.getInfoSource().size()>0){
                infoSourceService.saveOrUpdateBatch(aboutTable.getInfoSource());
            }
            if(aboutTable.getSubjectInfoSourceMap()!=null && aboutTable.getSubjectInfoSourceMap().size()>0){
                subjectInfoSourceMapService.saveOrUpdateBatch(aboutTable.getSubjectInfoSourceMap());
            }
            if(aboutTable.getInfoSourceGroup()!=null && aboutTable.getInfoSourceGroup().size()>0){
                infoSourceGroupService.saveOrUpdateBatch(aboutTable.getInfoSourceGroup());
            }
            if(aboutTable.getInfoSourceGroupMap()!=null && aboutTable.getInfoSourceGroupMap().size()>0){
                infoSourceGroupMapService.saveOrUpdateBatch(aboutTable.getInfoSourceGroupMap());
            }
            if(aboutTable.getGroupType()!=null && aboutTable.getGroupType().size()>0){
                groupTypeService.saveOrUpdateBatch(aboutTable.getGroupType());
            }
            if(aboutTable.getGroupTypeMap()!=null && aboutTable.getGroupTypeMap().size()>0){
                groupTypeMapService.saveOrUpdateBatch(aboutTable.getGroupTypeMap());
            }
        }catch (Exception e){
            log.error("专题：{}同步失败，e：{}",subjectId,e);
            return Result.FAIL("专题同步失败");
        }
        return Result.OK();
    }
}
