package com.zzsn.event.task;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.es.EsService;
import com.zzsn.event.util.RedisUtil;
import com.zzsn.event.vo.EventDigDataVO;
import com.zzsn.event.vo.KafkaDataVo;
import com.zzsn.event.vo.SubjectDataVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 事件挖掘任务
 *
 * @author lkg
 * @date 2024/8/30
 */
@Slf4j
@Component
public class EventDigTask {

    @Autowired
    private EsService esService;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private RedisUtil redisUtil;

    private final static String EVENT_DIG_TIME_KEY = "EVENT_DIG_HANDLER_TIME";

//    @Scheduled(cron = "0 0/3 * * * ?")
    public void sendData(){
        String startTime = null;
        Object object = redisUtil.get(EVENT_DIG_TIME_KEY);
        if (object != null) {
            startTime = object.toString();
        }
        List<EventDigDataVO> eventDigDataVOS = esService.pageListOfColumn("1828017348013912065", startTime, 120);
        if (CollectionUtils.isNotEmpty(eventDigDataVOS)) {
            //分批发送
            List<List<EventDigDataVO>> partition = ListUtils.partition(eventDigDataVOS, 30);
            partition.forEach(e -> kafkaTemplate.send(Constants.EVENT_DIG_SEND_TOPIC, JSON.toJSONString(e)));
            //将最新时间存入redis，供下次使用
            String processDate = eventDigDataVOS.get(eventDigDataVOS.size() - 1).getProcessDate();
            redisUtil.set(EVENT_DIG_TIME_KEY,processDate);
            log.info("事件挖掘数据，本次kafka推送开始时间为-{}，总条数为-{}",startTime,eventDigDataVOS.size());
        }
    }
}
