package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Data
@TableName("event")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="event对象", description="事件")
public class Event {
    
	/**ID*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "ID")
	private String id;
	/**编码*/
	@Excel(name = "编码", width = 15)
	@ApiModelProperty(value = "编码")
	private String eventCode;
	/**名称*/
	@Excel(name = "名称", width = 15)
    @ApiModelProperty(value = "名称")
	private String eventName;
	/**图标*/
	@Excel(name = "图标", width = 15)
    @ApiModelProperty(value = "图标")
	private String eventIcon;
	/**事件类型*/
	@Excel(name = "事件类型", width = 15)
    @ApiModelProperty(value = "事件类型")
	private String eventType;
	/**开始时间*/
	@Excel(name = "开始时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间")
	private Date startTime;
	/**结束时间*/
	@Excel(name = "结束时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间")
	private Date endTime;
	/**标签*/
	@Excel(name = "标签", width = 15)
    @ApiModelProperty(value = "标签")
	private String eventLabel;
	/**是否公开*/
	@Excel(name = "是否公开", width = 15)
    @ApiModelProperty(value = "是否公开")
	private Integer facePublic;
	/**事件描述*/
	@Excel(name = "事件描述", width = 15)
    @ApiModelProperty(value = "事件描述")
	private String eventDescribe;
	/**创建人id*/
	@Excel(name = "创建人id", width = 15)
    @ApiModelProperty(value = "创建人id")
	private String createBy;
	/**创建时间*/
	@Excel(name = "创建时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**修改时间*/
	@Excel(name = "修改时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
	private Date updateTime;
	/**修改人id*/
	@Excel(name = "修改人id", width = 15)
    @ApiModelProperty(value = "修改人id")
	private String updateBy;
	/**状态(0-禁用;1-启用)*/
	private Integer status=1;
	/**
	 * 专题最近一次分析时间
	 */
	@DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	private Date analysisTime;
	/**
	 * 分析事件脉络-最新资讯的时间
	 */
	@DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	private Date eventTime;
	/**划分专题库*/
	@Excel(name = "划分专题库", width = 15, dicCode = "Thematic_Library")
	@ApiModelProperty(value = "划分专题库")
	private String library;
	/**定时单位(1分；2小时；3日；4月)*/
	@ApiModelProperty(value = "定时单位")
	private String unit;
	/**定时数值*/
	@ApiModelProperty(value = "定时数值")
	private Integer space;
	/**cron表达式*/
	@ApiModelProperty(value = "cron表达式")
	private String cron;
	/**是否提取热词*/
	@ApiModelProperty(value = "是否提取热词")
	private String ynExtractHotWords;
	/**事件专题增量分析规则*/
	@ApiModelProperty(value = "事件专题增量分析规则")
	private Integer increAnaRule;
	/**事件专题总量分析规则*/
	@ApiModelProperty(value = "事件专题总量分析规则")
	private Integer totalAnaRule;
	/**事件专题时间间隔分析规则(天)*/
	@ApiModelProperty(value = "事件专题时间间隔分析规则(天)")
	private Integer timeAnaRule;
	/**总热度*/
	private Integer totalHot;
	/**媒体热度*/
	private Integer mediaHot;
	/**微信热度*/
	private Integer wechatHot;
	/**其他热度*/
	private Integer otherHot;
	/**发布状态(0-未发布;1-已发布)*/
	private Integer publishStatus;
	/**发布状态(0-未发布;1-已发布)*/
	private String relationEvents;
	/**发布时间*/
	private  String publishDate;
	/**排序号*/
	private Integer sortOrder;
	/**事件创建方式(1-用户创建;2-事件挖掘)*/
	private Integer category;



	@TableField(exist = false)
	private String typeName;
	@TableField(exist = false)
	private String startDate;
	@TableField(exist = false)
	private String endDate;
	@TableField(exist = false)
	private List<Event>  relatedEventList;
	@TableField(exist = false)
	private EventTag eventTag;
	@TableField(exist = false)
	private String extractIndustryTag;
	@TableField(exist = false)
	private String extractCompanyTag;
	@TableField(exist = false)
	private String extractPersonTag;
	@TableField(exist = false)
	private String extractSentimentTag;
	@TableField(exist = false)
	private String extractKeywordsTag;
	@TableField(exist = false)
	private String extractLocationTag;
	@TableField(exist = false)
	private String extractTimeTag;
}
