package com.zzsn.event.service;


import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.EventLlmConfig;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.vo.*;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lkg
 * @description: 专题分析
 * @date 2022/7/20 11:25
 */
public interface AnalysisService {

    /**
     * 事件脉络
     *
     * @param eventId 事件id
     * @param fakeNum 专题事件脉络展示 伪事件脉络 的资讯数量阈值
     * @return java.util.List<com.zzsn.subjectAnalysis.entity.SubjectAnalysis>
     */
    List<SubjectAnalysis> eventContext(String eventId, int fakeNum);

    /**
     * 事件脉络-新版
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/7
     */
    List<JSONObject> eventContext(String eventId);

    /**
     * 词云
     *
     * @param eventId   事件id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param size      返回热词个数
     * @author lkg
     * @date 2025/7/7
     */
    List<CountVO> wordCloud(String eventId, String startTime, String endTime, Integer size);

    /**
     * 关键词时间趋势
     *
     * @param eventId   事件id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2025/7/9
     */
    List<CountVO> wordTrend(String eventId, String startTime, String endTime);

    /**
     * 关键词共现
     *
     * @param eventId   事件id
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @author lkg
     * @date 2025/7/9
     */
    List<CoOccurrenceVO> coOccurrence(String eventId, String startTime, String endTime);

    /**
     * 传播路径
     *
     * @param eventId 事件id
     * @return com.zzsn.subjectAnalysis.vo.PropagationPathVo
     */
    PropagationPathVo propagationPath(String eventId);

    /**
     * 利用大模型生成的结果
     *
     * @param event              事件信息
     * @param startTime          开始时间
     * @param endTime            结束时间
     * @param llmConfig          模型配置信息
     * @param extraContentParams 额外输入参数(重新生成且为应对建议栏目时，会用到)
     * @author lkg
     * @date 2025/7/17
     */
    String llmResult(EventVO event, String content, String startTime, String endTime, EventLlmConfig llmConfig, Map<Integer, String> extraContentParams);

    String llmResult(String eventId, String content, String startTime, String endTime, Integer columnCode);

    /**
     * 重新生成
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/7
     */
    void regenerate(String eventId, String versionId);

    /**
     * 导出ppt
     *
     * @param eventId   事件id
     * @param versionId 版本id
     * @param content   导出内容
     * @author lkg
     * @date 2025/7/19
     */
    String exportPPT(String eventId, String versionId, JSONArray content);
}
