package com.zzsn.event.service;

import com.zzsn.event.entity.EventAnalysisVersionRecord;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.enums.AnalysisColumnEnum;

import java.util.List;

/**
 * @author lenovo
 * @description 针对表【event_analysis_version_record(事件分析版本记录表)】的数据库操作Service
 * @createDate 2025-07-16 16:34:46
 */
public interface EventAnalysisVersionRecordService extends IService<EventAnalysisVersionRecord> {

    /**
     * 获取版本下某栏目的数据
     *
     * @param versionId  版本id
     * @param columnCode 栏目编码
     * @author lkg
     * @date 2025/8/19
     */
    String getVersionData(String versionId, Integer columnCode);

    /**
     * 新增/编辑版本数据
     *
     * @param versionId          版本id
     * @param analysisColumnEnum 栏目枚举
     * @param data               结果数据
     * @author lkg
     * @date 2025/8/19
     */
    void modify(String versionId, AnalysisColumnEnum analysisColumnEnum, String data);

    /**
     * 获取版本下某些栏目的数据集合
     *
     * @param versionId  版本id
     * @param columnCodes 栏目编码
     * @author lkg
     * @date 2025/8/19
     */
    List<EventAnalysisVersionRecord> getVersionDataList(String versionId, Integer... columnCodes);
}
