package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectTypeMap;

import java.util.List;

/**
 * @Description: 专题与类别关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-01
 * @Version: V1.0
 */
public interface ISubjectTypeMapService extends IService<SubjectTypeMap> {

    /**根据专题id删除*/
    void deleteBySubjectId (String subjectId);

    /**
     * 分类下的专题id集合
     *
     * @param typeIds 分类id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> selectSubjectByTypeIds(List<String> typeIds);

    /**
     * 分类下的事件id集合
     *
     * @param typeIds 分类id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> selectEventByTypeIds(List<String> typeIds);
}
