package com.zzsn.event.util;

import com.alibaba.fastjson2.JSONObject;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lkg
 * @date 2023/2/17
 */
public class ObjectUtil {

    /**
     * 对象转jsonObject
     *
     * @param obj: 对象
     * @author lkg
     * @date 2023/2/17
     */
    public static JSONObject objectToJSONObject(Object obj) {
        JSONObject params = new JSONObject();
        if (obj == null) {
            return params;
        }
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.get(obj)!=null) {
                    params.put(field.getName(), field.get(obj));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    /**
     * 对象转map
     *
     * @param obj: 对象
     * @author lkg
     * @date 2023/2/17
     */
    public static Map<String, String> objectToMap(Object obj) {
        Map<String, String> map = new HashMap<>();
        if (obj == null) {
            return map;
        }
        Class clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                if(field.get(obj)!=null){
                    map.put(field.getName(), String.valueOf(field.get(obj)));
                }
            }
        } catch (

                Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}
