package com.zzsn.event.util;

import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.util.ArrayList;
import java.util.List;


/**
 * excel导出工具类(大批量数据)
 *
 * @author lkg
 * @date 2024-07-17
 */
public class BigExcelExportUtil {

	//多个sheet
	public static void exportExcelData(SXSSFWorkbook workbook, int sheetNum, List<String> keyList, List<List<String>> rows, String filename) {
		Sheet sheet = workbook.createSheet();
		//多个sheet
		workbook.setSheetName(sheetNum,filename);
		sheet.setDefaultColumnWidth(20);
		sheet.setDefaultRowHeight((short) 400);
		CellStyle titleStyle = getHeaderStyle(workbook);
		CellStyle rowStrStyle = getRowStrStyle(workbook);
		// 产生表格标题行
		Row row = sheet.createRow(0);
		row.setHeight((short) 400);
		Cell cell;
		List<String> colData = new ArrayList<>(keyList);
		for (int i = 0; i < colData.size(); i++) {
			cell = row.createCell(i, CellType.STRING);
			cell.setCellStyle(titleStyle);
			cell.setCellValue(colData.get(i));
		}
		// 数据行
		for (int m = 0; m < rows.size(); m++) {
			List<String>  rowData = rows.get(m);
			row = sheet.createRow(m + 1);
			row.setHeight((short) 400);
			int i=0;
			for (String rowDatum : rowData) {
				createCell(rowStrStyle, row, i, rowDatum);
				i++;
			}
		}
	}

	/**
	 * 获取标题栏样式
	 *
	 * @param workbook
	 * @return
	 */
	private static CellStyle getHeaderStyle(SXSSFWorkbook  workbook) {
		// 生成一个样式
		CellStyle style = workbook.createCellStyle();
		// 设置这些样式
		style.setFillForegroundColor(IndexedColors.SKY_BLUE.index);
		style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// style.setDataFormat(HSSFDataFormat.getBuiltinFormat("0.00"));
		// 生成一个字体
		Font font = workbook.createFont();
		font.setColor(IndexedColors.BLACK.index);
		font.setFontHeightInPoints((short) 9);
//		font.setBold(true);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}

	/**
	 * 获取字符串型内容栏样式
	 *
	 * @param workbook
	 * @return
	 */
	private static CellStyle getRowStrStyle(SXSSFWorkbook workbook) {
		// 生成一个样式
		CellStyle style = workbook.createCellStyle();
		// 设置这些样式
		//style.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		style.setBorderBottom(BorderStyle.THIN);
		style.setBorderLeft(BorderStyle.THIN);
		style.setBorderRight(BorderStyle.THIN);
		style.setBorderTop(BorderStyle.THIN);
		style.setAlignment(HorizontalAlignment.CENTER);
		// 生成一个字体
		Font font = workbook.createFont();
		font.setColor(IndexedColors.BLACK.index);
		font.setFontHeightInPoints((short) 9);
		font.setBold(true);
		// 把字体应用到当前的样式
		style.setFont(font);
		return style;
	}


	private static void createCell(CellStyle rowStrStyle, Row row, int index , String value){
		Cell cell = row.createCell(index, CellType.STRING);
		cell.setCellStyle(rowStrStyle);
		cell.setCellValue(value);
	}


}
