package com.zzsn.event.task;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.EventExtractTask;
import com.zzsn.event.es.EsService;
import com.zzsn.event.service.EventExtractTaskService;
import com.zzsn.event.util.DateUtil;
import com.zzsn.event.util.RedisUtil;
import com.zzsn.event.vo.EventDigDataVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * 事件挖掘任务
 *
 * @author lkg
 * @date 2024/8/30
 */
@Slf4j
@Component
public class EventDigTask {

    @Autowired
    private EventExtractTaskService eventExtractTaskService;
    @Autowired
    private EsService esService;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private RedisUtil redisUtil;

    private final static String EVENT_DIG_TIME_KEY = "EVENT_DIG_HANDLER_TIME::";

    /*@Scheduled(cron = "0 0/5 * * * ?")
    public void sendData() {
        List<EventExtractTask> extractTaskList = eventExtractTaskService.list(Wrappers.<EventExtractTask>lambdaQuery().eq(EventExtractTask::getDeleteStatus, 0)
                .eq(EventExtractTask::getTaskStatus, 1));
        for (EventExtractTask eventExtractTask : extractTaskList) {
            CompletableFuture.runAsync(() -> {
                String taskId = eventExtractTask.getId();
                eventExtractTaskService.update(Wrappers.<EventExtractTask>lambdaUpdate().set(EventExtractTask::getLastUpdateTime, new Date())
                        .eq(EventExtractTask::getId, taskId));
                String projectId = eventExtractTask.getProjectId();
                String columnId = eventExtractTask.getColumnId();
                Integer dataStatus = eventExtractTask.getDataStatus();
                String endTime = null;
                if (eventExtractTask.getEndTime() != null) {
                    endTime = DateUtil.dateToString(eventExtractTask.getEndTime());
                }
                String startTime = DateUtil.dateToString(eventExtractTask.getStartTime());

                String redisKey = EVENT_DIG_TIME_KEY + taskId;
                Object object = redisUtil.get(redisKey);
                if (object != null) {
                    startTime = object.toString();
                }
                List<EventDigDataVO> eventDigDataVOS = esService.pageListOfColumn(columnId, dataStatus, startTime, endTime, 120);
                if (CollectionUtils.isNotEmpty(eventDigDataVOS)) {
                    //分批发送
                    List<List<EventDigDataVO>> partition = ListUtils.partition(eventDigDataVOS, 30);
                    partition.forEach(e -> {
                        Map<String, Object> dataMap = new HashMap<>();
                        dataMap.put("taskId", taskId);
                        dataMap.put("projectId", projectId);
                        dataMap.put("dataList", e);
                        kafkaTemplate.send(Constants.EVENT_DIG_SEND_TOPIC, JSON.toJSONString(dataMap));
                    });
                    String processDate = eventDigDataVOS.get(eventDigDataVOS.size() - 1).getProcessDate();
                    if (endTime != null && processDate.compareTo(endTime) >= 0) {
                        eventExtractTaskService.update(Wrappers.<EventExtractTask>lambdaUpdate().set(EventExtractTask::getTaskStatus, 0)
                                .eq(EventExtractTask::getId, taskId));
                        log.info("事件抽取任务-{}，数据范围内的资讯已全部处理完，任务状态关闭", taskId);
                    } else {
                        //将最新时间存入redis，供下次使用
                        redisUtil.set(redisKey, processDate);
                        log.info("事件抽取任务-{}，本次kafka推送开始时间为-{}，总条数为-{}", taskId, startTime, eventDigDataVOS.size());
                    }
                }
            });
        }
    }*/
}
