package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @Description: 标签相关的实体
 * @Author: jeecg-boot
 * @Date:   2022-11-30
 * @Version: V1.0
 */
@Data
@TableName("label_entity")
@ApiModel(value="label_entity对象", description="标签相关的实体")
public class LabelEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
	/**名称*/
	@Excel(name = "名称", width = 15)
    @ApiModelProperty(value = "名称")
    private String name;
	/**近义词*/
	@Excel(name = "近义词", width = 15)
    @ApiModelProperty(value = "近义词")
    private String synonym;
	/**说明*/
	@Excel(name = "说明", width = 15)
    @ApiModelProperty(value = "说明")
    private String explanation;
	/**层级*/
	@Excel(name = "层级", width = 15)
    @ApiModelProperty(value = "层级")
    private Integer level;
	/**一级主键id*/
	@Excel(name = "一级主键id", width = 15)
    @ApiModelProperty(value = "一级主键id")
    private String topId;
	/**所有id*/
	@Excel(name = "所有id", width = 15)
    @ApiModelProperty(value = "所有id")
    private String pathIds;
	/**状态*/
	@Excel(name = "状态", width = 15)
    @ApiModelProperty(value = "状态")
    private Integer status;
	/**排序*/
	@Excel(name = "排序", width = 15)
    @ApiModelProperty(value = "排序")
    private Integer sort;
	/**父级节点*/
	@Excel(name = "父级节点", width = 15)
    @ApiModelProperty(value = "父级节点")
    private String pid;
	/**是否有子节点*/
	@Excel(name = "是否有子节点", width = 15, dicCode = "yn")
    @ApiModelProperty(value = "是否有子节点")
    private String hasChild;

    @TableField(exist = false)
    private String labelTypeId;
}
