package com.zzsn.event.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * dify大模型接口调用
 *
 * @author lkg
 * @date 2025/3/21
 */
@Slf4j
public class LLMUtil {


    final static String ChatGlm4_URL = "https://open.bigmodel.cn/api/paas/v4/chat/completions";
    //final static String API_KEY = "2eb40c7bb8e4d22b389cd9ada5a8d6cc.bAbE6g6y71TeC0on";
    final static String API_KEY = "c5a53bd5f95a4e37a8997deb5d0c6031.orXyRRPNvZiqRaxF";

    /**
     * LLM-推荐关键词
     *
     * @param keyword 关键词
     * @author lkg
     * @date 2025/3/21
     */
    public static List<String> wordRecommend(String keyword) {
        List<String> list = new ArrayList<>();
        JSONObject params = new JSONObject();
        List<JSONObject> messages = new ArrayList<>();
        JSONObject message = new JSONObject();
        String query = String.format("请推荐[%s]相关的10个近义词且只要结果", keyword);
        message.put("content", query);
        message.put("role", "user");
        messages.add(message);
        params.put("messages", messages);
        params.put("model", "glm-4-flash");
        JSONObject responseFormat = new JSONObject();
        responseFormat.put("type", "json_object");
        params.put("response_format", responseFormat);
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + API_KEY);
        String response = null;
        try {
            response = HttpUtil.doPostWithHeader(ChatGlm4_URL, params, 30000, headers);
            JSONObject jsonObject = JSON.parseObject(response);
            JSONArray choices = jsonObject.getJSONArray("choices");
            JSONObject choice = choices.getJSONObject(0);
            JSONObject content = choice.getJSONObject("message").getJSONObject("content");
            JSONArray answer = content.getJSONArray("answer");
            list = answer.toJavaList(String.class);
        } catch (Exception e) {
            log.info("大模型-{}，调用异常:{}","glm-4-flash",e.getMessage());
            log.info("返回结果：{}",response);
        }
        return list;
    }


    public static String crawlerWord(String remark) {
        String result = null;
        String prompt = "你是一个专业信息采集助手，根据用户提供的专题描述，精准提取核心实体和主题，生成符合以下规则的关键词表达式：\n" +
                "1. 用 `+` 表示 **与** 关系（必须同时出现）\n" +
                "2. 用 `|` 表示 **或** 关系（任一出现即可）\n" +
                "3. +两端的关键词组用 `()` 框选\n" +
                "4. 关键词必须直接来自描述或合理扩展的同义/关联词\n" +
                "5. 输出仅含表达式，无额外解释\n" +
                "6.+号使用不超过2个\n" +
                "7.不要把时间提取进表达式\n" +
                "\n" +
                "\n" +
                "### 示例\n" +
                "专题描述：\"星动纪元、云深处科技分别完成近5亿元融资，用于人形机器人研发与量产\"  \n" +
                "输出：(星动纪元|云深处科技)+(融资|量产)";
        JSONObject params = new JSONObject();
        List<JSONObject> messages = new ArrayList<>();
        JSONObject systemMap = new JSONObject();
        systemMap.put("role", "system");
        systemMap.put("content", prompt);
        messages.add(systemMap);
        JSONObject message = new JSONObject();
        message.put("content", remark);
        message.put("role", "user");
        messages.add(message);
        params.put("messages", messages);
        params.put("model", "glm-4-plus");
        JSONObject responseFormat = new JSONObject();
        responseFormat.put("type", "json_object");
        params.put("response_format", responseFormat);
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + API_KEY);
        String response = null;
        try {
            response = HttpUtil.doPostWithHeader(ChatGlm4_URL, params, 30000, headers);
            JSONObject jsonObject = JSON.parseObject(response);
            JSONArray choices = jsonObject.getJSONArray("choices");
            JSONObject choice = choices.getJSONObject(0);
            result = choice.getJSONObject("message").getString("content");
        } catch (Exception e) {
            log.info("大模型-{}，调用异常:{}","glm-4-plus",e.getMessage());
            log.info("返回结果：{}",response);
        }
        return result;
    }

    public static void main(String[] args) {
        //List<String> list = wordRecommend("人工智能|汽车");
        //System.out.println(JSON.toJSONString(list));
        String s = crawlerWord("2025年7月23日，东北大学6名学生在内蒙古中国黄金集团内蒙古矿业有限公司乌努格吐山铜钼矿选矿厂参观学习过程中不幸遇难。事故原因初步查明为浮选槽上方格栅板脱落。涉事公司已停产整顿，企业负责人及相关人员配合调查。内蒙古自治区政府成立调查组提级调查，事件善后工作正在进行中。");
        System.out.println(s);
    }
}
