package com.zzsn.event.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.zzsn.event.vo.log.DataLifecycleLog;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 操作类型枚举
 * 在数据生命周期日志{@link DataLifecycleLog}中记录
 *
 * @author 张宗涵
 * @date 2024/4/25
 */
@AllArgsConstructor
@Getter
public enum EnumOperateType {
    UNKNOWN("未知"),
    DATA_CRAWLER("数据采集"),
    PREPARE_HANDLER("数据预处理"),
    TO_SUBJECT("入专题库"),
    DEEP_HANDLER("数据深度处理"),
    DATA_CHECK("数据审核");

    private final String value;

    @JsonValue
    @Override
    public String toString() {
        return ordinal() + ":" + value;
    }

    /**
     * 获取操作类型对应的操作方式
     *
     * @param type
     * @return
     */
    public static List<EnumOperateWay> getOperateWays(EnumOperateType type) {
        switch (type) {
            case DATA_CRAWLER:
                return Arrays.stream(EnumOperateWay.values()).filter(way -> way.getParent() == EnumOperateType.DATA_CRAWLER).collect(Collectors.toList());
            case PREPARE_HANDLER:
                return Arrays.stream(EnumOperateWay.values()).filter(way -> way.getParent() == EnumOperateType.PREPARE_HANDLER).collect(Collectors.toList());
            case TO_SUBJECT:
                return Arrays.stream(EnumOperateWay.values()).filter(way -> way.getParent() == EnumOperateType.TO_SUBJECT).collect(Collectors.toList());
            case DEEP_HANDLER:
                return Arrays.stream(EnumOperateWay.values()).filter(way -> way.getParent() == EnumOperateType.DEEP_HANDLER).collect(Collectors.toList());
            case DATA_CHECK:
                return Arrays.stream(EnumOperateWay.values()).filter(way -> way.getParent() == EnumOperateType.DATA_CHECK).collect(Collectors.toList());
            default:
                return Collections.emptyList();
        }
    }

    /**
     * 获取操作类型
     *
     * @author lkg
     * @date 2024/5/22
     */
    public static List<EnumOperateType> getOperateTypes() {
        return Arrays.stream(EnumOperateType.values()).filter(type -> !type.value.equals(EnumOperateType.UNKNOWN.value)).collect(Collectors.toList());
    }
}
